/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa;

import org.hibernate.internal.util.StringHelper;

public enum SchemaGenSource {
    METADATA("metadata"),
    SCRIPT("script"),
    METADATA_THEN_SCRIPT("metadata-then-script"),
    SCRIPT_THEN_METADATA("script-then-metadata");

    private final String externalName;

    private SchemaGenSource(String externalName) {
        this.externalName = externalName;
    }

    public static SchemaGenSource interpret(String value) {
        if (StringHelper.isEmpty(value)) {
            return null;
        }
        if (SchemaGenSource.METADATA.externalName.equals(value)) {
            return METADATA;
        }
        if (SchemaGenSource.SCRIPT.externalName.equals(value)) {
            return SCRIPT;
        }
        if (SchemaGenSource.METADATA_THEN_SCRIPT.externalName.equals(value)) {
            return METADATA_THEN_SCRIPT;
        }
        if (SchemaGenSource.SCRIPT_THEN_METADATA.externalName.equals(value)) {
            return SCRIPT_THEN_METADATA;
        }
        throw new IllegalArgumentException("Unrecognized schema generation source value : " + value);
    }
}

