/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.index.task;

import org.apache.log4j.Logger;
import org.dataone.cn.index.task.IgnoringIndexIdPool;
import org.dataone.cn.index.task.IndexTask;
import org.dataone.service.types.v2.SystemMetadata;

public class IndexTaskGenerator {
    private static Logger logger = Logger.getLogger(IndexTaskGenerator.class.getName());

    public IndexTask generateAddTask(SystemMetadata smd, String objectURI) {
        if (IgnoringIndexIdPool.isNotIgnorePid(smd)) {
            IndexTask task = new IndexTask(smd, objectURI);
            task.setAddPriority();
            String id = "Unknow";
            if (smd != null && smd.getIdentifier() != null) {
                id = smd.getIdentifier().getValue();
            }
            return task;
        }
        return null;
    }

    public IndexTask generateUpdateTask(SystemMetadata smd, String objectURI) {
        if (IgnoringIndexIdPool.isNotIgnorePid(smd)) {
            IndexTask task = new IndexTask(smd, objectURI);
            task.setUpdatePriority();
            String id = "Unknow";
            if (smd != null && smd.getIdentifier() != null) {
                id = smd.getIdentifier().getValue();
            }
            return task;
        }
        return null;
    }

    public IndexTask generateDeleteTask(SystemMetadata smd) {
        if (IgnoringIndexIdPool.isNotIgnorePid(smd)) {
            IndexTask task = new IndexTask(smd, null);
            task.setDeleted(true);
            String id = "Unknow";
            if (smd != null && smd.getIdentifier() != null) {
                id = smd.getIdentifier().getValue();
            }
            return task;
        }
        return null;
    }

    public IndexTask generate(SystemMetadata smd, String objectURI, int priority) {
        if (IgnoringIndexIdPool.isNotIgnorePid(smd)) {
            IndexTask task = new IndexTask(smd, objectURI);
            task.setPriority(priority);
            String id = "Unknow";
            if (smd != null && smd.getIdentifier() != null) {
                id = smd.getIdentifier().getValue();
            }
            return task;
        }
        return null;
    }
}

