/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.batch.synchronization.tasks;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.apache.log4j.Logger;
import org.dataone.cn.batch.exceptions.ExecutionDisabledException;
import org.dataone.cn.batch.exceptions.RetryableException;
import org.dataone.cn.batch.synchronization.tasks.DelayWrapper;
import org.springframework.core.task.TaskRejectedException;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public abstract class QueueProcessorCallable<E, V>
implements Callable<String> {
    static final Logger logger = Logger.getLogger(QueueProcessorCallable.class);
    protected boolean inactivate = false;
    protected Queue<E> queue;
    protected DelayQueue<DelayWrapper<E>> pendingQueueItem = new DelayQueue();
    protected CircularFifoQueue<V> latestResults = new CircularFifoQueue(50);
    private static ThreadPoolTaskExecutor taskExecutor;
    private static final long EXECUTION_THREAD_TIMEOUT = 900000L;

    public void setQueue(Queue<E> queue) {
        this.queue = queue;
    }

    public void setThreadPoolTaskExecutor(ThreadPoolTaskExecutor taskExecutor) {
        QueueProcessorCallable.taskExecutor = taskExecutor;
    }

    @Override
    public String call() throws Exception {
        HashMap<FutureTask<FutureStat>, FutureStat> activeFutures = new HashMap<FutureTask<FutureStat>, FutureStat>();
        try {
            while (true) {
                E queueItem;
                this.reapFutures(activeFutures);
                if (this.isInactivated()) {
                    if (activeFutures.isEmpty() & this.pendingQueueItem.isEmpty()) {
                        logger.info((Object)"All Tasks are complete. Shutting down\n");
                        throw new ExecutionDisabledException();
                    }
                    if (this.pendingQueueItem.isEmpty()) {
                        this.interruptableSleep(3000L);
                    }
                }
                if ((queueItem = this.getNextItem()) == null) continue;
                Callable<V> callable = this.prepareTask(queueItem);
                try {
                    FutureTask<V> scheduledFuture = this.scheduleExecution(callable);
                    activeFutures.put(scheduledFuture, new FutureStat(new Date(), queueItem));
                }
                catch (TaskRejectedException e) {
                    this.pendingQueueItem.add(new DelayWrapper<E>(queueItem));
                    this.interruptableSleep(2000L);
                }
                this.cancelStuckTasks(activeFutures);
            }
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
            return "Interrupted";
        }
    }

    private E getNextItem() throws InterruptedException {
        DelayWrapper delayWrapper = (DelayWrapper)this.pendingQueueItem.poll();
        if (delayWrapper != null) {
            return (E)delayWrapper.getWrappedObject();
        }
        if (this.isInactivated()) {
            return null;
        }
        if (this.queue instanceof BlockingQueue) {
            return ((BlockingQueue)this.queue).poll(250L, TimeUnit.MILLISECONDS);
        }
        return this.queue.poll();
    }

    private FutureTask<V> scheduleExecution(Callable<V> callable) throws TaskRejectedException {
        FutureTask<V> futureTask = new FutureTask<V>(callable);
        taskExecutor.execute(futureTask);
        return futureTask;
    }

    private void interruptableSleep(Long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException iex) {
            logger.debug((Object)"sleep interrupted");
        }
    }

    private void cancelStuckTasks(HashMap<FutureTask<V>, FutureStat> activeFutures) {
        if (taskExecutor.getActiveCount() >= taskExecutor.getPoolSize()) {
            if (taskExecutor.getPoolSize() == taskExecutor.getMaxPoolSize() && activeFutures.isEmpty()) {
                BlockingQueue<Runnable> blockingTaskQueue = taskExecutor.getThreadPoolExecutor().getQueue();
                Runnable[] taskArray = new Runnable[]{};
                taskArray = blockingTaskQueue.toArray(taskArray);
                for (int j = 0; j < taskArray.length; ++j) {
                    taskExecutor.getThreadPoolExecutor().remove(taskArray[j]);
                }
            }
            taskExecutor.getThreadPoolExecutor().purge();
        }
    }

    protected abstract Callable<V> prepareTask(E var1);

    protected abstract void cleanupTask(E var1);

    protected void setIsInactivated(boolean inactivate) {
        logger.warn((Object)("Setting processor inactivation: " + inactivate));
        this.inactivate = inactivate;
    }

    protected boolean isInactivated() {
        return this.inactivate;
    }

    private void reapFutures(HashMap<FutureTask<V>, FutureStat> activeFutures) throws InterruptedException {
        if (activeFutures.size() > 0) {
            logger.info((Object)("waiting on " + activeFutures.size() + " futures"));
        } else {
            logger.debug((Object)"Polling empty queue");
        }
        if (!activeFutures.isEmpty()) {
            ArrayList<FutureTask<V>> removalList = new ArrayList<FutureTask<V>>();
            for (FutureTask<V> future : activeFutures.keySet()) {
                try {
                    V v = future.get(250L, TimeUnit.MILLISECONDS);
                    this.latestResults.add(v);
                    this.cleanupTask(activeFutures.get(future).queueItem);
                    removalList.add(future);
                }
                catch (CancellationException cancellationException) {
                    this.cleanupTask(activeFutures.get(future).queueItem);
                    this.pendingQueueItem.add(new DelayWrapper(activeFutures.get(future).queueItem, 0L));
                    removalList.add(future);
                }
                catch (ExecutionException executionException) {
                    if (executionException.getCause() != null && executionException.getCause() instanceof RetryableException) {
                        logger.debug((Object)"Adding item to pendingQueue...");
                        this.pendingQueueItem.add(new DelayWrapper(activeFutures.get(future).queueItem, ((RetryableException)executionException.getCause()).getDelay()));
                    }
                    this.cleanupTask(activeFutures.get(future).queueItem);
                    removalList.add(future);
                }
                catch (TimeoutException timeoutException) {
                    if (new Date().getTime() - activeFutures.get(future).start.getTime() <= 900000L) continue;
                    if (future.cancel(true)) {
                        this.cleanupTask(activeFutures.get(future).queueItem);
                        removalList.add(future);
                    } else {
                        logger.warn((Object)"unable to cancel this future task!");
                    }
                    if (!taskExecutor.getThreadPoolExecutor().remove(future)) continue;
                }
            }
            if (!removalList.isEmpty()) {
                for (Future future : removalList) {
                    activeFutures.remove(future);
                }
            }
        }
    }

    class FutureStat {
        Date start;
        E queueItem;

        FutureStat(Date start, E queueItem) {
            this.start = start;
            this.queueItem = queueItem;
        }
    }
}

