/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.EnvironmentStatsInternal;
import com.sleepycat.je.dbi.INList;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.IN;
import java.util.Iterator;

public class MemoryBudget {
    public static final long LN_OVERHEAD = 24L;
    public static final long IN_FIXED_OVERHEAD = 235L;
    public static final long BIN_FIXED_OVERHEAD = 400L;
    public static final long BYTE_ARRAY_OVERHEAD = 12L;
    public static final long OBJECT_OVERHEAD = 8L;
    public static final long KEY_OVERHEAD = 32L;
    public static final long LSN_SIZE = 16L;
    public static final long ARRAY_ITEM_OVERHEAD = 4L;
    private static final long N_64MB = 0x4000000L;
    private volatile long cacheMemoryUsage;
    private long maxMemory;
    private long logBufferBudget;
    private long treeBudget;
    private long inOverhead;
    private long binOverhead;
    private EnvironmentImpl envImpl;
    static final /* synthetic */ boolean $assertionsDisabled;

    MemoryBudget(EnvironmentImpl envImpl, DbConfigManager configManager) throws DatabaseException {
        this.envImpl = envImpl;
        this.maxMemory = configManager.getLong(EnvironmentParams.MAX_MEMORY);
        long jvmMemory = MemoryBudget.getRuntimeMaxMemory();
        if (jvmMemory == Long.MAX_VALUE) {
            jvmMemory = 0x4000000L;
        }
        if (this.maxMemory != 0L) {
            if (jvmMemory < this.maxMemory) {
                throw new IllegalArgumentException(EnvironmentParams.MAX_MEMORY.getName() + " has a value of " + this.maxMemory + " but the JVM is only configured for " + jvmMemory + ". Consider using je.maxMemoryPercent.");
            }
        } else {
            int maxMemoryPercent = configManager.getInt(EnvironmentParams.MAX_MEMORY_PERCENT);
            this.maxMemory = (long)maxMemoryPercent * jvmMemory / 100L;
        }
        this.logBufferBudget = configManager.getLong(EnvironmentParams.LOG_MEM_SIZE);
        if (this.logBufferBudget == 0L) {
            this.logBufferBudget = this.maxMemory >> 4;
        } else if (this.logBufferBudget > this.maxMemory / 2L) {
            this.logBufferBudget = this.maxMemory / 2L;
        }
        int numBuffers = configManager.getInt(EnvironmentParams.NUM_LOG_BUFFERS);
        long startingBufferSize = this.logBufferBudget / (long)numBuffers;
        int logBufferSize = configManager.getInt(EnvironmentParams.LOG_BUFFER_MAX_SIZE);
        if (startingBufferSize > (long)logBufferSize) {
            startingBufferSize = logBufferSize;
            this.logBufferBudget = (long)numBuffers * startingBufferSize;
        }
        this.treeBudget = this.maxMemory - this.logBufferBudget;
        this.inOverhead = IN.computeOverhead(configManager);
        this.binOverhead = BIN.computeOverhead(configManager);
    }

    public static long getRuntimeMaxMemory() {
        long jvmMemory = Runtime.getRuntime().maxMemory();
        if (jvmMemory != Long.MAX_VALUE && jvmMemory > 0x4000000L && "Mac OS X".equals(System.getProperty("os.name")) && "1.4.2_03".equals(System.getProperty("java.version"))) {
            jvmMemory -= 0x4000000L;
        }
        return jvmMemory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initCacheMemoryUsage() throws DatabaseException {
        long totalSize = 0L;
        INList inList = this.envImpl.getInMemoryINs();
        inList.latchMajor();
        try {
            Iterator iter = inList.iterator();
            while (iter.hasNext()) {
                IN in = (IN)iter.next();
                long size = in.getInMemorySize();
                totalSize += size;
            }
        }
        finally {
            inList.releaseMajorLatch();
        }
        if (!$assertionsDisabled && Latch.countLatchesHeld() != 0) {
            throw new AssertionError();
        }
        this.cacheMemoryUsage = totalSize;
    }

    public void updateCacheMemoryUsage(long increment) {
        this.cacheMemoryUsage += increment;
        if (this.cacheMemoryUsage > this.treeBudget) {
            this.envImpl.alertEvictor();
        }
    }

    public long accumulateNewUsage(IN in, long newSize) {
        return in.getInMemorySize() + newSize;
    }

    public void refreshCacheMemoryUsage(long newSize) {
        this.cacheMemoryUsage = newSize;
    }

    public long getCacheMemoryUsage() {
        return this.cacheMemoryUsage;
    }

    public long getLogBufferBudget() {
        return this.logBufferBudget;
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public long getTreeBudget() {
        return this.treeBudget;
    }

    public long getINOverhead() {
        return this.inOverhead;
    }

    public long getBINOverhead() {
        return this.binOverhead;
    }

    void loadStats(StatsConfig config, EnvironmentStatsInternal stats) {
        stats.setCacheDataBytes(this.getCacheMemoryUsage());
    }

    static {
        $assertionsDisabled = !MemoryBudget.class.desiredAssertionStatus();
    }
}

