/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.sse.lang;

import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.lang.ParseHandler;

public class ParseHandlerDebug
implements ParseHandler {
    int count = 0;

    private void indent() {
        for (int i = 0; i < this.count; ++i) {
            System.out.print("  ");
        }
    }

    private void start(int line, int column) {
        System.out.print("[" + line + ", " + column + "]  ");
        this.indent();
    }

    public Item getItem() {
        return null;
    }

    public void parseStart() {
        System.out.println("<<<<");
    }

    public void parseFinish() {
        System.out.println(">>>>");
    }

    public void listStart(int line, int column) {
        this.start(line, column);
        ++this.count;
        System.out.println("(");
    }

    public void listFinish(int line, int column) {
        --this.count;
        this.start(line, column);
        System.out.println(")");
    }

    public void emitBNode(int line, int column, String label) {
        this.start(line, column);
        System.out.println("BNode: " + label);
    }

    public void emitIRI(int line, int column, String iriStr) {
        this.start(line, column);
        System.out.println("IRI: " + iriStr);
    }

    public void emitLiteral(int line, int column, String lex, String lang, String datatype_iri, String datatype_pn) {
        this.start(line, column);
        if (lang != null) {
            System.out.println("Literal: " + lex + " @" + lang);
        } else if (datatype_iri != null) {
            System.out.println("Literal: " + lex + " ^^" + datatype_iri);
        } else if (datatype_pn != null) {
            System.out.println("Literal: " + lex + " ^^" + datatype_pn);
        }
    }

    public void emitPName(int line, int column, String pname) {
        this.start(line, column);
        System.out.println("PName: " + pname);
    }

    public void emitSymbol(int line, int column, String symbol) {
        this.start(line, column);
        System.out.println("Symbol: " + symbol);
    }

    public void emitVar(int line, int column, String varName) {
        this.start(line, column);
        System.out.println("Var: " + varName);
    }
}

