
package org.dataone.service.types;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dataone.service.exceptions.UnsupportedType;

/** 
 * A string used to identify an instance of
 :class:`Types.ObjectFormat` and MUST be unique within an instance of
 :class:`Types.ObjectFormatList`. 
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://tst.dataone.org/service/types/v1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjectFormatIdentifier">
 *   &lt;xs:restriction base="xs:string"/>
 * &lt;/xs:simpleType>
 * </pre>
 */
public class ObjectFormatIdentifier implements Serializable, Comparable
{
    private static final long serialVersionUID = 10000000;
    private final String NONEMPTY_REGEX = "^[\\s]*[\\S][\\S+\\s+]*$";
    Pattern pattern = Pattern.compile(NONEMPTY_REGEX);
    private String value;

    /** 
     * Get the 'ObjectFormatIdentifier' simpleType value.
     * 
     * @return value
     */
    public String getValue() {
        return value;
    }

    /** 
     * Set the 'ObjectFormatIdentifier' simpleType value.
     * 
     * @param value
     */
    public void setValue(String value) throws UnsupportedType {
        Matcher nonWhitespaceMatcher = pattern.matcher(value);
        if (nonWhitespaceMatcher.find()) {
            this.value = value;
        } else {
            throw new UnsupportedType(
                    "000",
                    value
                            + " does not conform to specification of org.dataone.service.types.ObjectFormatIdentifier");
        }
    }

    /** 
     * Default Constructor for a generated class
     */
    public ObjectFormatIdentifier() {
        value = null;
    }

    /** 
     * ObjectFormatIdentifier Constructor that takes a single field
     * @param value is java.lang.String.
     */
    public ObjectFormatIdentifier(java.lang.String value)
            throws UnsupportedType {
        this.setValue(value);
    }

    /** 
     * 1 value 2 Value 3 String 4 (java.lang.String) 5 ObjectFormatIdentifier  value is a string, override equals of ObjectFormatIdentifier.
     * @param other
     * @return boolean
     */
    @Override
    public boolean equals(Object other) {
        if (other == null || other.getClass() != this.getClass())
            return false;
        ObjectFormatIdentifier otherObjectFormatIdentifier = (ObjectFormatIdentifier) other;
        return value.equals(otherObjectFormatIdentifier.getValue());
    }

    /** 
     * return the hashcode of ObjectFormatIdentifier's string value.
     * @return int
     */
    @Override
    public int hashCode() {
        return value.hashCode();
    }

    /** 
     * Compares order based on the String value of two objects of the same type.
     * @param other
     * @return int
     * @throws ClassCastException 
     */
    @Override
    public int compareTo(Object other) throws ClassCastException {
        ObjectFormatIdentifier otherObjectFormatIdentifier = (ObjectFormatIdentifier) other;
        return value.compareTo(otherObjectFormatIdentifier.getValue());
    }
}
