
package org.dataone.service.types;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://tst.dataone.org/service/types/v1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NonEmptyContainer">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Subject" name="subject" minOccurs="1" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:Identifier" name="identifier" minOccurs="1" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:NodeReference" name="nodeReference" minOccurs="1" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:ObjectFormatIdentifier" name="objectFormatIdentifier" minOccurs="1" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class NonEmptyContainer implements Serializable
{
    private static final long serialVersionUID = 10000000;
    private List<Subject> subjectList = new ArrayList<Subject>();
    private List<Identifier> identifierList = new ArrayList<Identifier>();
    private List<NodeReference> nodeReferenceList = new ArrayList<NodeReference>();
    private List<ObjectFormatIdentifier> objectFormatIdentifierList = new ArrayList<ObjectFormatIdentifier>();

    /** 
     * Get the list of 'subject' element items.
     * 
     * @return list
     */
    public List<Subject> getSubjectList() {
        return subjectList;
    }

    /** 
     * Set the list of 'subject' element items.
     * 
     * @param list
     */
    public void setSubjectList(List<Subject> list) {
        subjectList = list;
    }

    /** 
     * Get the list of 'identifier' element items.
     * 
     * @return list
     */
    public List<Identifier> getIdentifierList() {
        return identifierList;
    }

    /** 
     * Set the list of 'identifier' element items.
     * 
     * @param list
     */
    public void setIdentifierList(List<Identifier> list) {
        identifierList = list;
    }

    /** 
     * Get the list of 'nodeReference' element items.
     * 
     * @return list
     */
    public List<NodeReference> getNodeReferenceList() {
        return nodeReferenceList;
    }

    /** 
     * Set the list of 'nodeReference' element items.
     * 
     * @param list
     */
    public void setNodeReferenceList(List<NodeReference> list) {
        nodeReferenceList = list;
    }

    /** 
     * Get the list of 'objectFormatIdentifier' element items.
     * 
     * @return list
     */
    public List<ObjectFormatIdentifier> getObjectFormatIdentifierList() {
        return objectFormatIdentifierList;
    }

    /** 
     * Set the list of 'objectFormatIdentifier' element items.
     * 
     * @param list
     */
    public void setObjectFormatIdentifierList(List<ObjectFormatIdentifier> list) {
        objectFormatIdentifierList = list;
    }
}
