
package org.dataone.service.types;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dataone.service.exceptions.UnsupportedType;

/** 
 * A unique identifier for a DataONE Node. The
 *NodeReference* must be unique across nodes, and must always be
 assigned to one Member or Coordinating Node instance even in the event of 
 the *BaseURL* or other characteristics changing.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://tst.dataone.org/service/types/v1" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NodeReference">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="xs:string"/>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class NodeReference implements Serializable, Comparable
{
    private static final long serialVersionUID = 10000000;
    private final String NONEMPTY_REGEX = "^[\\s]*[\\S][\\S+\\s+]*$";
    Pattern pattern = Pattern.compile(NONEMPTY_REGEX);
    private String value;

    /** 
     * Get the 'NodeReference' complexType value.
     * 
     * @return value
     */
    public String getValue() {
        return value;
    }

    /** 
     * Set the 'NodeReference' complexType value.
     * 
     * @param value
     */
    public void setValue(String value) throws UnsupportedType {
        Matcher nonWhitespaceMatcher = pattern.matcher(value);
        if (nonWhitespaceMatcher.find()) {
            this.value = value;
        } else {
            throw new UnsupportedType(
                    "000",
                    value
                            + " does not conform to specification of org.dataone.service.types.NodeReference");
        }
    }

    /** 
     * Default Constructor for a generated class
     */
    public NodeReference() {
        value = null;
    }

    /** 
     * NodeReference Constructor that takes a single field
     * @param value is java.lang.String.
     */
    public NodeReference(java.lang.String value) throws UnsupportedType {
        this.setValue(value);
    }

    /** 
     * 1 value 2 Value 3 String 4 (java.lang.String) 5 NodeReference  value is a string, override equals of NodeReference.
     * @param other
     * @return boolean
     */
    @Override
    public boolean equals(Object other) {
        if (other == null || other.getClass() != this.getClass())
            return false;
        NodeReference otherNodeReference = (NodeReference) other;
        return value.equals(otherNodeReference.getValue());
    }

    /** 
     * return the hashcode of NodeReference's string value.
     * @return int
     */
    @Override
    public int hashCode() {
        return value.hashCode();
    }

    /** 
     * Compares order based on the String value of two objects of the same type.
     * @param other
     * @return int
     * @throws ClassCastException 
     */
    @Override
    public int compareTo(Object other) throws ClassCastException {
        NodeReference otherNodeReference = (NodeReference) other;
        return value.compareTo(otherNodeReference.getValue());
    }
}
