/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.dataone.jibx.schema.codegen;

import java.util.ArrayList;
import java.util.List;
import org.dataone.service.exceptions.UnsupportedType;
import org.dataone.service.types.Identifier;
import org.dataone.service.types.NodeReference;
import org.dataone.service.types.ObjectFormatIdentifier;
import org.dataone.service.types.Person;
import org.dataone.service.types.Subject;
import org.junit.Test;
import static org.junit.Assert.*;
/**
 * Test string assignments to classes generated from 
 * NonEmptyNoWhitespaceString800TypeDecorator and
 * NonEmptyStringTypeDecorator
 * 
 * @author waltz
 */
public class NonEmptyStringsTestCase {
    
    /* This should test a valid string assigned to a class generated with 
     * NonEmptyNoWhitespaceString800TypeDecorator or
     * NonEmptyStringTypeDecorator
     * 
     * @author waltz
     */
    @Test
    public void validNonEmptyStringAssignments() throws UnsupportedType  {
        String nonEmptyNodeString= "urn:node:A_Valid_MNNode";
        
        NodeReference nodeReferenceTest = new NodeReference();
        nodeReferenceTest.setValue(nonEmptyNodeString);
        assertTrue(nodeReferenceTest.getValue().equals(nonEmptyNodeString));
        
        String nonEmptyHttpString = "http://dublincore.org/schemas/xmls/qdc/2008/02/11/simpledc.xsd";
        System.out.println(nonEmptyHttpString);
        
        ObjectFormatIdentifier objectFormatIdentifierTest = new ObjectFormatIdentifier();
        objectFormatIdentifierTest.setValue(nonEmptyHttpString);
        assertTrue(objectFormatIdentifierTest.getValue().equals(nonEmptyHttpString));
        
        String nonEmptySubjectTest = "CN=Benjamin Leinfelder A515,O=University of Chicago,C=US,DC=cilogon,DC=org";
        Subject subjectTest = new Subject();
        subjectTest.setValue(nonEmptySubjectTest);
        assertTrue(subjectTest.getValue().equals(nonEmptySubjectTest));
        
        String nonEmptyIdentifer = "ark:/13030/m53b5zjd/1/cadwsap-s3301529-004-vuln.csv";
        Identifier identifierTest = new Identifier();
        identifierTest.setValue(nonEmptyIdentifer);
        assertTrue(identifierTest.getValue().equals(nonEmptyIdentifer));
        
        List<String> givenNameList = new ArrayList<String>();
        givenNameList.add("Vera");
        givenNameList.add("Chuck");
        givenNameList.add("Dave");
        Person person = new Person();
        person.setGivenNameList(givenNameList);
        assertFalse(person.getGivenNameList().isEmpty());
    }
    
    /* This should test an invalid string assigned to NodeReference generated with 
     * NonEmptyStringTypeDecorator
     * 
     * @author waltz
     */
    @Test(expected=UnsupportedType.class)
    public void inValidNodeReferenceAssignment() throws UnsupportedType {

        String nonEmptyNodeString= "";
        
        NodeReference nodeReferenceTest = new NodeReference();
        nodeReferenceTest.setValue(nonEmptyNodeString);
        // should never make it here
        fail("should throw an UnsupportedType exception");
     }
    /* This should test an invalid string assigned to ObjectFormatIdentifier generated with 
     * NonEmptyStringTypeDecorator
     * 
     * @author waltz
     */
    @Test(expected=UnsupportedType.class)
    public void inValidObjectFormatIdentifierAssignment() throws UnsupportedType {

        String nonEmptyHttpString = "     ";
        
        ObjectFormatIdentifier objectFormatIdentifierTest = new ObjectFormatIdentifier();
        objectFormatIdentifierTest.setValue(nonEmptyHttpString);
        // should never make it here
        fail("should throw an UnsupportedType exception");
     }
    /* This should test an invalid string assigned to Subject generated with 
     * NonEmptyStringTypeDecorator
     * 
     * @author waltz
     */
    @Test(expected=UnsupportedType.class)
    public void inValidSubjectAssignment() throws UnsupportedType {

        String nonEmptySubjectTest = "\t\n";
        Subject subjectTest = new Subject();
        subjectTest.setValue(nonEmptySubjectTest);
        // should never make it here
        fail("should throw an UnsupportedType exception");
     }
    /* This should test an invalid string assigned to Identifier generated with 
     * NonEmptyNoWhitespaceString800TypeDecorator
     * 
     * @author waltz
     */
    @Test(expected=UnsupportedType.class)
    public void inValidIdentifierAssignment() throws UnsupportedType {

        String nonEmptyIdentifer = "ark:/13030/m53b5zjd/1/ cadwsap-s3301529-004-vuln.csv";
        Identifier identifierTest = new Identifier();
        identifierTest.setValue(nonEmptyIdentifer);
        // should never make it here
        fail("should throw an UnsupportedType exception");

    }
    /* This should test an invalid string assigned to a list generated with 
     * NonEmptyNoWhitespaceString
     * 
     * @author waltz
     */
    @Test(expected=UnsupportedType.class)
    public void inValidSetPersonGivenNameAssignment() throws UnsupportedType {
        List<String> givenNameList = new ArrayList<String>();
        givenNameList.add("Vera");
        givenNameList.add("Chuck");
        givenNameList.add(" ");
        Person person = new Person();
        person.setGivenNameList(givenNameList);

    }
    
}
