/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.dataone.jibx.schema.codegen;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import javax.xml.XMLConstants;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.dataone.service.exceptions.UnsupportedType;
import org.dataone.service.types.NonEmptyContainer;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.junit.Test;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import static org.junit.Assert.*;
/**
 * Make certain that marshalling valid content will work and unmarshalling invalid content will fail
 *
 * @author waltz
 */
public class MarshallingNonEmptyContainerTest {

    static private String testExtendedTypes = "/org/dataone/service/resources/testExtendedTypes.xsd";
    static private String validNonEmptyContainer = "/org/dataone/service/samples/ValidNonEmptyContainer.xml";
    static private String invalidNonEmptyContainerEmptySubject = "/org/dataone/service/samples/InvalidNonEmptyContainerEmptySubject.xml";
    static private String invalidNonEmptyContainerWhitespaceonlySubject = "/org/dataone/service/samples/InvalidNonEmptyContainerWhitespaceonlySubject.xml";
    static private String invalidNonEmptyContainerEmptyIdentifier = "/org/dataone/service/samples/InvalidNonEmptyContainerEmptyIdentifier.xml";
    static private String invalidNonEmptyContainerIdentifierWithWhitespace = "/org/dataone/service/samples/InvalidNonEmptyContainerIdentifierWithWhitespace.xml";
    
    /* verify the valid test document itself will validate against the test schema
     * 
     * @author waltz
     */

    @Test
    public void verifyValidNonEmptyContainer() throws Exception {
        validateExamples(testExtendedTypes, validNonEmptyContainer);
    }
    /* 
     * verify the marshaller will work with valid content
     * 
     * @author waltz
     */
    @Test
    public void deserializeValidNonEmptyContainer() throws Exception {
        deserializeNonEmptyContainer(this.getClass().getResourceAsStream(validNonEmptyContainer));

    }
    /* verify the invalid test documents fail against the test schema
     * test xml file has an empty Subject
     * 
     * @author waltz
     */
    @Test(expected=SAXParseException.class)
    public void verifyInvalidNonEmptyContainerEmptySubject() throws Exception {
        validateExamples(testExtendedTypes, invalidNonEmptyContainerEmptySubject);

    }

    /* 
     * verify unmarshalling will fail with invalid content
     * test xml file has an empty Subject
     * 
     * @author waltz
     */
    @Test(expected=JiBXException.class)
    public void deserializeInvalidNonEmptyContainerEmptySubject() throws Exception {
        deserializeNonEmptyContainer(this.getClass().getResourceAsStream(invalidNonEmptyContainerEmptySubject));

    }
    /* verify the invalid test documents fail against the test schema
     * test xml file has a Subject that only contains whitespace
     * 
     * @author waltz
     */
    @Test(expected=SAXParseException.class)
    public void verifyInvalidNonEmptyContainerWhitespaceonlySubject() throws Exception {
        validateExamples(testExtendedTypes, invalidNonEmptyContainerWhitespaceonlySubject);

    }
    
    /* 
     * verify unmarshalling will fail with invalid content
     * test xml file has a Subject that only contains whitespace
     * 
     * @author waltz
     */
    @Test(expected=JiBXException.class)
    public void deserializeInvalidNonEmptyContainerWhitespaceonlySubject() throws Exception {
        deserializeNonEmptyContainer(this.getClass().getResourceAsStream(invalidNonEmptyContainerEmptySubject));

    }
    /*
     * verify the invalid test documents fail against the test schema
     * test xml file has an empty Identifier
     * 
     * @author waltz
     */
    @Test(expected=SAXParseException.class)
    public void verifyInvalidNonEmptyContainerEmptyIdentifier() throws Exception {
        validateExamples(testExtendedTypes, invalidNonEmptyContainerEmptyIdentifier);

    }
    
    /* 
     * verify unmarshalling will fail with invalid content
     * test xml file has an empty Identifier
     * 
     * @author waltz
     */
    @Test(expected=JiBXException.class)
    public void deserializeInvalidNonEmptyContainerEmptyIdentifier() throws Exception {
        deserializeNonEmptyContainer(this.getClass().getResourceAsStream(invalidNonEmptyContainerEmptyIdentifier));
    }
    
    /* verify the invalid test documents fail against the test schema
     * test xml file has an Identifier with whitespace in it
     * 
     * @author waltz
     */
    @Test(expected=SAXParseException.class)
    public void verifyInvalidNonEmptyContainerIdentifierWithWhitespace() throws Exception {
        validateExamples(testExtendedTypes, invalidNonEmptyContainerIdentifierWithWhitespace);

    }
    
    /* 
     * verify unmarshalling will fail with invalid content
     * test xml file has an Identifier with whitespace in it
     * 
     * @author waltz
     */
    @Test(expected=JiBXException.class)
    public void deserializeInvalidNonEmptyContainerIdentifierWithWhitespace() throws Exception {
        deserializeNonEmptyContainer(this.getClass().getResourceAsStream(invalidNonEmptyContainerIdentifierWithWhitespace));

    }
    private void deserializeNonEmptyContainer(InputStream xmlInputStream) throws JiBXException, IOException {
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(NonEmptyContainer.class);
            IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
            NonEmptyContainer nonEmptyContainer = (NonEmptyContainer) uctx.unmarshalDocument(xmlInputStream, null);
        } finally {
            xmlInputStream.close();
        }
    }
    private boolean validateExamples(String xsdUrlString, String xmlDocument) throws Exception, SAXException, IOException, ParserConfigurationException {
        return validateExamples(this.getClass().getResourceAsStream(xsdUrlString), this.getClass().getResourceAsStream(xmlDocument));
    }
    
    private boolean validateExamples(InputStream xsdUrlStream, InputStream xmlInputStream) throws Exception, SAXException, IOException, ParserConfigurationException {
        DocumentBuilder parser;
        // create a SchemaFactory capable of understanding WXS schemas
        SchemaFactory factory = SchemaFactory.newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI);
        Document document;
        Schema schema;
        Source schemaFile;

        // load a WXS schema, represented by a Schema instance

        schemaFile = new StreamSource(xsdUrlStream);
        schema = factory.newSchema(schemaFile);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();

        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setSchema(schema);
        documentBuilderFactory.setValidating(false);

        parser = documentBuilderFactory.newDocumentBuilder();
        // load in the file to validate
        document = parser.parse(xmlInputStream);

        // create a Validator instance, which can be used to validate an instance document

        ValidateXmlDocument validateXmlDocument = new ValidateXmlDocument(schema);


        // validate the DOM tree

        return validateXmlDocument.validate(document);

    }

    /**
     *
     * @author Robert P Waltz.
     */
    private class ValidateXmlDocument {

        private class ErrorHandlerImpl implements ErrorHandler {

            public void warning(SAXParseException exception) throws SAXException {
                System.out.print(exception.getMessage());
                // do nothing;
            }

            public void error(SAXParseException exception) throws SAXException {
                System.out.print(exception.getMessage());
//	            logger.warn(exception.getMessage());
                throw exception;
            }

            public void fatalError(SAXParseException exception) throws SAXException {
                System.out.print(exception.getMessage());
//	            logger.warn(exception.getMessage());
                throw exception;
            }
        }
        private Validator validator = null;

        public ValidateXmlDocument(Schema schema) {
            // TODO Auto-generated constructor stub
            try {
                ErrorHandlerImpl errorHandlerImpl = new ErrorHandlerImpl();

                validator = schema.newValidator();
                validator.setErrorHandler(errorHandlerImpl);
            } catch (Exception e) {
//                logger.error("FATAL ERROR: INITIALIZATION OF XML VALIDATE SERVICE IMPL\n",e);
                validator = null;
            }
        }

        public boolean validate(Document document) throws SAXException, Exception {


            DOMSource domSource = new DOMSource(document);
            if (domSource == null) {
                throw new Exception("TEI SOURCE IS NULL");
            }
            validator.validate(domSource);

            return true;
        }

        public String toString(Document document) throws Exception {
            String result = null;

            if (document != null) {
                StringWriter strWtr = new StringWriter();
                StreamResult strResult = new StreamResult(strWtr);
                TransformerFactory tfac = TransformerFactory.newInstance();

                Transformer t = tfac.newTransformer();
                t.setOutputProperty(OutputKeys.ENCODING, "UTF-8");
                t.setOutputProperty(OutputKeys.INDENT, "yes");
                t.setOutputProperty(OutputKeys.METHOD, "xml"); //xml, html, text
                t.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                t.transform(new DOMSource(document.getDocumentElement()), strResult);

                result = strResult.getWriter().toString();
            }

            return result;
        }//toString()
    }
}
