/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.dataone.jibx.schema.codegen.extend;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.jibx.schema.codegen.extend.ClassDecorator;
import org.jibx.schema.codegen.extend.NameMatchDecoratorBase;

/**
 *
 * Base class for decorators which match on the a field name list.
 *
 * @author waltz
 */
public abstract class FieldMatchDecoratorBase extends NameMatchDecoratorBase implements ClassDecorator {

    /**
     * list of fields from the fields attribute of the class-decorator element
     */
    protected List<String> m_fields = new ArrayList<String>();

    /**
     *
     * Default constructor to initialize m_fields with the default String field 'value' that is used in Dataone. Note if
     * this were to be generalized, then 'string' would also be added.
     *
     */
    public FieldMatchDecoratorBase() {
        super();
        m_fields.add("value");
    }

    /**
     * Set the elements to an array.
     *
     * @param name
     */
    public void setFields(String fields) {
        System.out.println(fields);
        m_fields.addAll(Arrays.asList(fields.split("\\s+")));
    }

    protected Type getFieldType(AST ast, String fieldName) {
        StringTokenizer st = new StringTokenizer(fieldName, ".");
        ArrayList<String> fieldList = new ArrayList<String>();
        ArrayList<SimpleName> simpleNameList = new ArrayList<SimpleName>();
        while (st.hasMoreTokens()) {
            String name = st.nextToken().trim();
            fieldList.add(name);
        }
        if (fieldList.isEmpty()) {
            // use the fieldName as provided
            return ast.newSimpleType(ast.newSimpleName(fieldName));
        }
        if (fieldList.size() == 1) {
            // just make this a simple name
            return ast.newSimpleType(ast.newSimpleName(fieldList.get(0)));
        }
        if (fieldList.size() > 1) {

            QualifiedType qualifiedFieldType = null;
            SimpleType simpleFieldType = null;
            for (String field : fieldList) {
                if (qualifiedFieldType == null && simpleFieldType == null) {
                    simpleFieldType = ast.newSimpleType(ast.newSimpleName(field));
                } else if (qualifiedFieldType == null) {
                    qualifiedFieldType = ast.newQualifiedType(simpleFieldType, ast.newSimpleName(field));
                } else {
                    qualifiedFieldType = ast.newQualifiedType(qualifiedFieldType, ast.newSimpleName(field));
                }
            }
            return qualifiedFieldType;
        }
        throw new IllegalArgumentException("building a Type from field attribute '" + fieldName + "' did not work");
    }
}
