/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.datamanager;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ecoinformatics.datamanager.database.ConnectionNotAvailableException;
import org.ecoinformatics.datamanager.database.DatabaseAdapter;
import org.ecoinformatics.datamanager.database.DatabaseConnectionPoolInterface;
import org.ecoinformatics.datamanager.database.DatabaseHandler;
import org.ecoinformatics.datamanager.database.HSQLAdapter;
import org.ecoinformatics.datamanager.database.OracleAdapter;
import org.ecoinformatics.datamanager.database.PostgresAdapter;
import org.ecoinformatics.datamanager.database.Query;
import org.ecoinformatics.datamanager.database.TableMonitor;
import org.ecoinformatics.datamanager.database.Union;
import org.ecoinformatics.datamanager.download.DataStorageInterface;
import org.ecoinformatics.datamanager.download.DownloadHandler;
import org.ecoinformatics.datamanager.download.EcogridEndPointInterface;
import org.ecoinformatics.datamanager.parser.Attribute;
import org.ecoinformatics.datamanager.parser.AttributeList;
import org.ecoinformatics.datamanager.parser.DataPackage;
import org.ecoinformatics.datamanager.parser.Entity;
import org.ecoinformatics.datamanager.parser.generic.DataPackageParserInterface;
import org.ecoinformatics.datamanager.parser.generic.Eml200DataPackageParser;
import org.ecoinformatics.datamanager.quality.QualityCheck;
import org.ecoinformatics.datamanager.quality.QualityReport;

public class DataManager {
    public static Log log = LogFactory.getLog(DataManager.class);
    private static DataManager dataManager = null;
    private static String databaseAdapterName = null;
    private static DatabaseConnectionPoolInterface connectionPool = null;
    private static final String BLANKSTR = "";
    private static final int MAXIMUM_NUMBER_TO_ACCESS_CONNECTIONPOOL = 10;
    private static final int SLEEP_TIME = 2000;

    private DataManager(DatabaseConnectionPoolInterface connectionPool, String databaseAdapterName) {
        DataManager.connectionPool = connectionPool;
        DataManager.databaseAdapterName = databaseAdapterName;
    }

    public static DataManager getInstance(DatabaseConnectionPoolInterface connectionPool, String databaseAdapterName) {
        if (dataManager == null) {
            dataManager = new DataManager(connectionPool, databaseAdapterName);
        } else if (DataManager.databaseAdapterName != null && !DataManager.databaseAdapterName.equals(databaseAdapterName)) {
            dataManager = new DataManager(connectionPool, databaseAdapterName);
        }
        return dataManager;
    }

    public static Connection getConnection() throws SQLException {
        Connection connection = null;
        if (connectionPool == null) {
            throw new SQLException("The Connection Pool is null");
        }
        for (int index = 0; index < 10; ++index) {
            try {
                connection = connectionPool.getConnection();
                break;
            }
            catch (ConnectionNotAvailableException cna) {
                try {
                    Thread.sleep(2000L);
                }
                catch (Exception e) {
                    log.error((Object)("Error in DataManager.getConnection(): " + e.getMessage()));
                }
                continue;
            }
            catch (SQLException sql) {
                log.error((Object)("Error in DataManager.getConnection(): " + sql.getMessage()));
            }
        }
        return connection;
    }

    public static void returnConnection(Connection connection) {
        connectionPool.returnConnection(connection);
    }

    public static String getDatabaseAdapterName() {
        return databaseAdapterName;
    }

    public static DatabaseConnectionPoolInterface getDatabaseConnectionPool() {
        return connectionPool;
    }

    public boolean createDataView(String ANSISQL, Entity[] entityList) {
        boolean success = true;
        return success;
    }

    public boolean downloadData(DataPackage dataPackage, EcogridEndPointInterface endPointInfo, DataStorageInterface[] dataStorageList) {
        boolean success = true;
        Entity[] entities = dataPackage.getEntityList();
        for (int i = 0; i < entities.length; ++i) {
            Entity entity = entities[i];
            success = this.downloadData(entity, endPointInfo, dataStorageList) && success;
        }
        return success;
    }

    public boolean downloadData(Entity entity, EcogridEndPointInterface endPointInfo, DataStorageInterface[] dataStorageList) {
        boolean preserveFormat = false;
        return this.downloadData(entity, endPointInfo, dataStorageList, preserveFormat);
    }

    public boolean downloadData(Entity entity, EcogridEndPointInterface endPointInfo, DataStorageInterface[] dataStorageList, boolean preserveFormat) {
        log.debug((Object)String.format("***** Downloading data for: %s, entity: %s\n", entity.getPackageId(), entity.getName()));
        DownloadHandler downloadHandler = entity.getDownloadHandler(endPointInfo, preserveFormat);
        boolean success = false;
        if (downloadHandler != null) {
            try {
                success = downloadHandler.download(dataStorageList);
            }
            catch (Exception e) {
                log.error((Object)("Error downloading entity name '" + entity.getName() + "': " + e.getMessage()));
                success = false;
            }
        }
        return success;
    }

    public boolean downloadData(InputStream metadataInputStream, EcogridEndPointInterface endPointInfo, DataStorageInterface[] dataStorageList) throws Exception {
        boolean success = false;
        DataPackage dataPackage = this.parseMetadata(metadataInputStream);
        if (dataPackage != null) {
            success = this.downloadData(dataPackage, endPointInfo, dataStorageList);
        }
        return success;
    }

    public boolean dropTables(DataPackage dataPackage) throws ClassNotFoundException, SQLException, Exception {
        DatabaseHandler databaseHandler = new DatabaseHandler(databaseAdapterName);
        boolean success = databaseHandler.dropTables(dataPackage);
        return success;
    }

    public boolean dropTables(String packageId) throws ClassNotFoundException, SQLException, Exception {
        DatabaseHandler databaseHandler = new DatabaseHandler(databaseAdapterName);
        boolean success = databaseHandler.dropTables(packageId);
        return success;
    }

    public boolean createTables(DataPackage dataPackage) throws SQLException, Exception {
        DatabaseHandler databaseHandler = new DatabaseHandler(databaseAdapterName);
        boolean success = databaseHandler.generateTables(dataPackage);
        return success;
    }

    public static String getDBFieldName(Entity entity, Attribute attribute) throws SQLException {
        String entityName;
        String packageID;
        String[] dbFieldNames;
        Attribute[] attributeArray;
        String dbFieldName = null;
        dbFieldName = attribute.getDBFieldName();
        if ((dbFieldName == null || dbFieldName.trim().equals(BLANKSTR)) && entity != null && attribute != null && (attributeArray = entity.getAttributes()).length == (dbFieldNames = DataManager.getDBFieldNames(packageID = entity.getPackageId(), entityName = entity.getName())).length) {
            for (int i = 0; i < attributeArray.length; ++i) {
                Attribute arrayAttribute = attributeArray[i];
                if (!attribute.equals(arrayAttribute)) continue;
                dbFieldName = dbFieldNames[i];
            }
        }
        return dbFieldName;
    }

    public static String[] getDBFieldNames(String packageID, String entityName) throws SQLException {
        String[] dbFieldNames = null;
        DatabaseAdapter dbAdapter = DataManager.getDatabaseAdapterObject(databaseAdapterName);
        TableMonitor tableMonitor = new TableMonitor(dbAdapter);
        dbFieldNames = tableMonitor.getDBFieldNames(packageID, entityName);
        return dbFieldNames;
    }

    public static String getDBTableName(String packageID, String entityName) throws SQLException {
        String dbTableName = null;
        DatabaseAdapter dbAdapter = DataManager.getDatabaseAdapterObject(databaseAdapterName);
        TableMonitor tableMonitor = new TableMonitor(dbAdapter);
        dbTableName = tableMonitor.getDBTableName(packageID, entityName);
        return dbTableName;
    }

    public static String getDBTableName(Entity entity) throws SQLException {
        String dbTableName = null;
        if (entity != null && ((dbTableName = entity.getDBTableName()) == null || dbTableName.trim().equals(BLANKSTR))) {
            String packageID = entity.getPackageId();
            String entityName = entity.getName();
            dbTableName = DataManager.getDBTableName(packageID, entityName);
        }
        return dbTableName;
    }

    public boolean loadDataToDB(DataPackage dataPackage, EcogridEndPointInterface endPointInfo) throws ClassNotFoundException, SQLException, Exception {
        boolean success = true;
        Entity[] entities = dataPackage.getEntityList();
        for (int i = 0; i < entities.length; ++i) {
            success = this.loadDataToDB(entities[i], endPointInfo) && success;
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadDataToDB(Entity entity, EcogridEndPointInterface endPointInfo) throws ClassNotFoundException, SQLException, Exception {
        boolean success = false;
        log.debug((Object)String.format("***** Loading data to DB for: %s, entity: %s\n", entity.getPackageId(), entity.getName()));
        String qualityCheckIdentifier = "dataLoadStatus";
        QualityCheck qualityCheckTemplate = QualityReport.getQualityCheckTemplate(qualityCheckIdentifier);
        QualityCheck dataLoadQualityCheck = new QualityCheck(qualityCheckIdentifier, qualityCheckTemplate);
        if (entity != null && entity.isOtherEntity()) {
            AttributeList attributeList = entity.getAttributeList();
            if (attributeList == null) {
                success = true;
            } else {
                Attribute[] attributes = attributeList.getAttributes();
                if (attributes == null) {
                    success = true;
                }
            }
            if (success && QualityCheck.shouldRunQualityCheck(entity, dataLoadQualityCheck)) {
                dataLoadQualityCheck.setFound("Data loading was not attempted for this 'otherEntity' because no attribute list was found in the EML");
                dataLoadQualityCheck.setExplanation("In EML, a data entity of type 'otherEntity' is not required to document an attribute list");
                entity.addQualityCheck(dataLoadQualityCheck);
            }
        } else if (entity != null && !entity.hasDistributionOnline() && (entity.hasDistributionOffline() || entity.hasDistributionInline())) {
            success = true;
            if (QualityCheck.shouldRunQualityCheck(entity, dataLoadQualityCheck)) {
                dataLoadQualityCheck.setFound("Data loading was not attempted for this entity because its distribution is 'inline' or 'offline'");
                dataLoadQualityCheck.setExplanation("Unable to process data entities with distribution set to 'inline' or 'offline'");
                entity.addQualityCheck(dataLoadQualityCheck);
            }
        } else {
            try {
                DatabaseHandler databaseHandler = new DatabaseHandler(databaseAdapterName);
                success = databaseHandler.generateTable(entity);
                if (success && !(success = databaseHandler.loadDataToDB(entity, endPointInfo))) {
                    databaseHandler.dropTable(entity);
                }
            }
            catch (SQLException e) {
                success = false;
            }
        }
        return success;
    }

    public boolean loadDataToDB(InputStream metadataInputStream, EcogridEndPointInterface endPointInfo) throws Exception {
        boolean success = false;
        DataPackage dataPackage = this.parseMetadata(metadataInputStream);
        if (dataPackage != null) {
            success = this.loadDataToDB(dataPackage, endPointInfo);
        }
        return success;
    }

    public DataPackage parseMetadata(InputStream metadataInputStream) throws Exception {
        DataPackage dataPackage = null;
        Eml200DataPackageParser parser = new Eml200DataPackageParser();
        parser.parse(metadataInputStream);
        dataPackage = parser.getDataPackage();
        this.dataPackageQuality(dataPackage);
        return dataPackage;
    }

    public DataPackage parseMetadata(InputStream metadataInputStream, DataPackageParserInterface genericParser) throws Exception {
        DataPackage dataPackage = null;
        genericParser.parse(metadataInputStream);
        dataPackage = genericParser.getDataPackage();
        this.dataPackageQuality(dataPackage);
        return dataPackage;
    }

    private void dataPackageQuality(DataPackage dataPackage) {
        String duplicateEntityIdentifier = "duplicateEntityName";
        QualityCheck duplicateEntityTemplate = QualityReport.getQualityCheckTemplate(duplicateEntityIdentifier);
        QualityCheck duplicateEntityQualityCheck = new QualityCheck(duplicateEntityIdentifier, duplicateEntityTemplate);
        if (QualityCheck.shouldRunQualityCheck(dataPackage, duplicateEntityQualityCheck)) {
            boolean hasDuplicate;
            String duplicateName = dataPackage.findDuplicateEntityName();
            boolean bl = hasDuplicate = duplicateName != null;
            if (hasDuplicate) {
                duplicateEntityQualityCheck.setFound("Found duplicate entity name: " + duplicateName);
                duplicateEntityQualityCheck.setFailedStatus();
            } else {
                duplicateEntityQualityCheck.setFound("No duplicates found");
                duplicateEntityQualityCheck.setStatus(QualityCheck.Status.valid);
            }
            dataPackage.addDatasetQualityCheck(duplicateEntityQualityCheck);
        }
    }

    public ResultSet selectData(Query query, DataPackage[] packages) throws ClassNotFoundException, SQLException, Exception {
        ResultSet resultSet = null;
        DatabaseHandler databaseHandler = new DatabaseHandler(databaseAdapterName);
        String ANSISQL = query.toSQLString();
        resultSet = databaseHandler.selectData(ANSISQL, packages);
        return resultSet;
    }

    public ResultSet selectData(Query query, InputStream[] emlInputStreams) throws Exception {
        DataPackage[] packages = new DataPackage[emlInputStreams.length];
        ResultSet resultSet = null;
        for (int i = 0; i < emlInputStreams.length; ++i) {
            DataPackage dataPackage;
            packages[i] = dataPackage = this.parseMetadata(emlInputStreams[i]);
        }
        resultSet = this.selectData(query, packages);
        return resultSet;
    }

    public ResultSet selectData(Union union, DataPackage[] packages) throws ClassNotFoundException, SQLException, Exception {
        ResultSet resultSet = null;
        DatabaseHandler databaseHandler = new DatabaseHandler(databaseAdapterName);
        String ANSISQL = union.toSQLString();
        resultSet = databaseHandler.selectData(ANSISQL, packages);
        return resultSet;
    }

    public ResultSet selectDataFromView(String ANSISQL) {
        ResultSet resultSet = null;
        return resultSet;
    }

    public void setDatabaseAdapterName(String databaseAdapterName) {
        DataManager.databaseAdapterName = databaseAdapterName;
    }

    public void setDatabaseSize(int size) throws SQLException, ClassNotFoundException {
        DatabaseAdapter dbAdapter = DataManager.getDatabaseAdapterObject(databaseAdapterName);
        TableMonitor tableMonitor = new TableMonitor(dbAdapter);
        tableMonitor.setDBSize(size);
    }

    public void setTableExpirationPolicy(String tableName, int policy) throws SQLException, ClassNotFoundException {
        DatabaseAdapter dbAdapter = DataManager.getDatabaseAdapterObject(databaseAdapterName);
        TableMonitor tableMonitor = new TableMonitor(dbAdapter);
        tableMonitor.setTableExpirationPolicy(tableName, policy);
    }

    public static DatabaseAdapter getDatabaseAdapterObject(String dbAdapterName) {
        if (dbAdapterName == null) {
            return null;
        }
        if (dbAdapterName.equals("PostgresAdapter")) {
            PostgresAdapter databaseAdapter = new PostgresAdapter();
            return databaseAdapter;
        }
        if (dbAdapterName.equals("HSQLAdapter")) {
            HSQLAdapter databaseAdapter = new HSQLAdapter();
            return databaseAdapter;
        }
        if (dbAdapterName.equals("OracleAdapter")) {
            OracleAdapter databaseAdapter = new OracleAdapter();
            return databaseAdapter;
        }
        return null;
    }
}

