/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.utility.versiontool;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.lang3.StringUtils;

public class ComponentVersionInfo {
    private final DateFormat format = new SimpleDateFormat("MM/dd/yyyy:HH:mm");
    private static final String D1_VERSION = "D1-version";
    private static final String D1_BRANCH = "D1-SCM-Branch";
    private static final String D1_REVISION = "D1-SCM-Revision";
    private static final String D1_BUILD_TIME = "D1-Build-TimeStamp";
    private String name = "";
    private String path = "";
    private String version = "";
    private String branch = "";
    private String revision = "";
    private long buildTime;
    private String buildTimeString = "";
    private boolean dependent = false;
    private List<ComponentVersionInfo> dependencies = new ArrayList<ComponentVersionInfo>();

    public ComponentVersionInfo(String artifactName, String path, String version, String branch, String revision, long buildMilliseconds) {
        this.name = artifactName;
        if (path != null) {
            this.path = path;
        }
        if (version != null) {
            this.version = version;
        }
        if (branch != null) {
            this.branch = branch;
        }
        if (revision != null) {
            this.revision = revision;
        }
        this.buildTime = buildMilliseconds;
        this.buildTimeString = this.format.format(new Date(buildMilliseconds));
    }

    public ComponentVersionInfo(String name, String path, Manifest manifest) {
        this.name = name;
        if (path != null) {
            this.path = path;
        }
        if (manifest != null) {
            Attributes attribs = manifest.getMainAttributes();
            if (attribs.getValue(D1_VERSION) != null) {
                this.version = attribs.getValue(D1_VERSION);
            }
            if (attribs.getValue(D1_BRANCH) != null) {
                this.branch = attribs.getValue(D1_BRANCH);
            }
            if (attribs.getValue(D1_REVISION) != null) {
                this.revision = attribs.getValue(D1_REVISION);
            }
            if (StringUtils.isNotEmpty(attribs.getValue(D1_BUILD_TIME))) {
                this.buildTime = Long.parseLong(attribs.getValue(D1_BUILD_TIME));
                this.buildTimeString = this.format.format(this.buildTime);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getRevision() {
        return this.revision;
    }

    public long getBuildTime() {
        return this.buildTime;
    }

    public String getBuildTimeString() {
        return this.buildTimeString;
    }

    public boolean isDependent() {
        return this.dependent;
    }

    public boolean isMainComponent() {
        return !this.dependent;
    }

    private void setDependent(boolean depVal) {
        this.dependent = depVal;
    }

    public void addDependency(ComponentVersionInfo cvi) {
        cvi.setDependent(true);
        this.dependencies.add(cvi);
    }

    public List<ComponentVersionInfo> getDependencies() {
        return this.dependencies;
    }
}

