/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.utility.versiontool;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.lang3.StringUtils;
import org.dataone.cn.utility.versiontool.ComponentInfoNameAlphabetizer;
import org.dataone.cn.utility.versiontool.ComponentVersionInfo;
import org.dataone.cn.utility.versiontool.ComponentVersionReportTool;

public class JarAppVersionReporter {
    private static final String NAME = "D1-Component";
    private static final String VERSION = "D1-version";
    private static final String BRANCH = "D1-SCM-Branch";
    private static final String REVISION = "D1-SCM-Revision";
    private static final String BUILD_DATE = "D1-Build-TimeStamp";
    public static final String newline = System.getProperty("line.separator");
    private String PROPERTIES_FILE_PATH = null;
    private static final String JAVA_APP_PATH_KEY = "java_app_path";
    private static ArrayList<String> jarAppPaths = new ArrayList();

    public JarAppVersionReporter(String propertyFilePath) {
        if (propertyFilePath != null) {
            this.PROPERTIES_FILE_PATH = propertyFilePath;
        }
    }

    public static void main(String[] args) throws IOException {
        String path = "/Users/sroseboo/development/workspace/indexer/d1_cn_index_tool/target/d1_index_build_tool.jar";
        JarFile jarFile = new JarFile(path);
        JarEntry entry = jarFile.getJarEntry("buildInfo/buildInfo.properties");
        InputStream input = jarFile.getInputStream(entry);
        ComponentVersionInfo component = JarAppVersionReporter.buildComponentInformation(input, path);
        jarFile.close();
        StringBuilder buffer = new StringBuilder();
        ComponentVersionReportTool.getTextOutput(buffer, Collections.singletonList(component));
        System.out.println(buffer.toString());
    }

    public Collection<ComponentVersionInfo> report(StringBuilder log) {
        ArrayList<ComponentVersionInfo> jarCompList = new ArrayList<ComponentVersionInfo>();
        if (this.setPropertiesFromFile(log)) {
            for (String javaAppPath : jarAppPaths) {
                try {
                    InputStream input;
                    ComponentVersionInfo component;
                    File testFile = new File(javaAppPath);
                    if (!testFile.exists()) continue;
                    JarFile jarFile = new JarFile(javaAppPath);
                    JarEntry entry = jarFile.getJarEntry("buildInfo/buildInfo.properties");
                    if (entry != null && (component = JarAppVersionReporter.buildComponentInformation(input = jarFile.getInputStream(entry), javaAppPath)) != null) {
                        jarCompList.add(component);
                    }
                    jarFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return jarCompList;
    }

    private static ComponentVersionInfo buildComponentInformation(InputStream input, String path) throws IOException {
        String line;
        InputStreamReader isr = new InputStreamReader(input);
        BufferedReader reader = new BufferedReader(isr);
        ComponentVersionInfo componentInfo = null;
        String name = "";
        String version = "";
        String branch = "";
        String revision = "";
        long buildTime = 0L;
        boolean firstName = true;
        while ((line = reader.readLine()) != null) {
            if (!line.contains("=")) continue;
            String key = StringUtils.split(line, "=")[0];
            String value = StringUtils.split(line, "=")[1];
            if (NAME.equals(key) && name.equals("")) {
                name = value;
                continue;
            }
            if (NAME.equals(key)) {
                if (firstName) {
                    firstName = false;
                    componentInfo = new ComponentVersionInfo(name, path, version, branch, revision, buildTime);
                } else {
                    boolean dupe = false;
                    for (ComponentVersionInfo cvi : componentInfo.getDependencies()) {
                        if (!cvi.getName().equals(name) || !cvi.getVersion().equals(version) || !cvi.getRevision().equals(revision)) continue;
                        dupe = true;
                        break;
                    }
                    if (!dupe) {
                        componentInfo.addDependency(new ComponentVersionInfo(name, path, version, branch, revision, buildTime));
                    }
                }
                name = value;
                path = "";
                version = "";
                branch = "";
                revision = "";
                buildTime = 0L;
                continue;
            }
            if (VERSION.equals(key)) {
                version = value;
                continue;
            }
            if (BRANCH.equals(key)) {
                branch = value;
                continue;
            }
            if (REVISION.equals(key)) {
                revision = value;
                continue;
            }
            if (!BUILD_DATE.equals(key)) continue;
            buildTime = Long.valueOf(value);
        }
        boolean dupe = false;
        if (componentInfo != null) {
            for (ComponentVersionInfo cvi : componentInfo.getDependencies()) {
                if (!cvi.getName().equals(name) || !cvi.getVersion().equals(version) || !cvi.getRevision().equals(revision)) continue;
                dupe = true;
                break;
            }
            if (!dupe) {
                componentInfo.addDependency(new ComponentVersionInfo(name, path, version, branch, revision, buildTime));
            }
            reader.close();
            Collections.sort(componentInfo.getDependencies(), new ComponentInfoNameAlphabetizer());
        }
        return componentInfo;
    }

    public boolean setPropertiesFromFile(StringBuilder log) {
        boolean returnValue = true;
        if (this.PROPERTIES_FILE_PATH != null) {
            File file = new File(this.PROPERTIES_FILE_PATH);
            if (file.exists() && file.canRead()) {
                try {
                    String line;
                    BufferedReader in = new BufferedReader(new FileReader(file));
                    while ((line = in.readLine()) != null) {
                        String key = StringUtils.substringBefore(line, "=");
                        key = StringUtils.trim(key);
                        String value = StringUtils.substringAfter(line, "=");
                        value = StringUtils.trim(value);
                        if (JAVA_APP_PATH_KEY.compareTo(key) != 0) continue;
                        jarAppPaths.add(value);
                    }
                    in.close();
                }
                catch (FileNotFoundException fnfe) {
                    returnValue = false;
                    log.append("Unable to locate properties file.  Please add default property file or pass one in via command line." + newline);
                }
                catch (IOException ioe) {
                    returnValue = false;
                    log.append("Unable to read properties file.  Please add default property file or pass one in via command line." + newline);
                }
            } else {
                returnValue = false;
                log.append("Unable to locate properties file: Please add default property file or pass one in via command line." + newline);
            }
        } else {
            returnValue = false;
            log.append("No property file provided.  Please add default property file or pass one in via command line." + newline);
        }
        return returnValue;
    }
}

