/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.utility.versiontool;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.dataone.cn.utility.versiontool.ComponentVersionInfo;
import org.dataone.cn.utility.versiontool.JarAppVersionReporter;
import org.dataone.cn.utility.versiontool.WebAppVersionReporter;

public class ComponentVersionReportTool {
    public static final String newline = System.getProperty("line.separator");

    public static void main(String[] args) {
        String propertyFilePath = null;
        boolean outputHtml = false;
        boolean showHelp = false;
        for (String arg : args) {
            if (StringUtils.startsWith(arg, "-F")) {
                propertyFilePath = StringUtils.substringAfter(arg, "-F");
                continue;
            }
            if (StringUtils.startsWith(arg, "-html")) {
                outputHtml = true;
                continue;
            }
            if (!StringUtils.startsWith(arg, "-help")) continue;
            showHelp = true;
        }
        if (propertyFilePath == null || showHelp) {
            ComponentVersionReportTool.showHelp();
            return;
        }
        StringBuilder log = new StringBuilder();
        StringBuilder output = new StringBuilder();
        WebAppVersionReporter webAppUtil = new WebAppVersionReporter(propertyFilePath);
        Collection<ComponentVersionInfo> warReports = webAppUtil.report(log);
        JarAppVersionReporter jarAppUtil = new JarAppVersionReporter(propertyFilePath);
        Collection<ComponentVersionInfo> jarReports = jarAppUtil.report(log);
        if (outputHtml) {
            ComponentVersionReportTool.getHtmlOutput(output, warReports, jarReports, log);
            System.out.print(output.toString());
        } else {
            System.out.print(log);
            ComponentVersionReportTool.getTextOutput(output, warReports);
            System.out.print(output.toString());
        }
    }

    public static void showHelp() {
        System.out.println("DataONE CN stack version tool help:");
        System.out.println(" ");
        System.out.println("This tool generates version reports on the local dataONE CN stack.");
        System.out.println("   This tool uses a properties file to find components to report on.");
        System.out.println("   This property file must be specified at run time.  A default version");
        System.out.println("   should be distributed with this tool: version-tool.properties.");
        System.out.println(" ");
        System.out.println("-F     Specifies the file path to the properites file to use to discover");
        System.out.println("       CN components. For example, if the properties file is in the");
        System.out.println("       same directory:");
        System.out.println("             -F./version-tool.properties");
        System.out.println(" ");
        System.out.println("-html  The default report output is plain text.  To generate an html");
        System.out.println("       document use this option.");
        System.out.println(" ");
        System.out.println("-help  To see this help text.");
        System.out.println(" ");
        System.out.println("Example of complete command:");
        System.out.println("   ./dataone-cn-version-tool.sh -F./version-tool.properties -html > version.html");
        System.out.println("This will output the html document to a file called version.html using a ");
        System.out.println("property file called version-tool.properties in the same directory.");
    }

    public static void getTextOutput(StringBuilder output, Collection<ComponentVersionInfo> warReports) {
        if (warReports.size() > 0) {
            output.append("CN web application component versions:" + newline);
            for (ComponentVersionInfo warCompInfo : warReports) {
                ComponentVersionReportTool.getComponentTextOutput(output, warCompInfo);
                output.append(newline);
                for (ComponentVersionInfo depVersionInfo : warCompInfo.getDependencies()) {
                    ComponentVersionReportTool.getComponentTextOutput(output, depVersionInfo);
                    output.append(newline);
                }
                output.append(newline);
            }
        } else {
            output.append("No CN web application components found." + newline);
        }
    }

    private static void getComponentTextOutput(StringBuilder output, ComponentVersionInfo componentVersionInfo) {
        if (componentVersionInfo.isDependent()) {
            output.append("       ");
        } else {
            output.append("Component: ");
        }
        output.append(componentVersionInfo.getName());
        if (StringUtils.isNotEmpty(componentVersionInfo.getPath())) {
            output.append(" PATH: " + componentVersionInfo.getPath());
        }
        if (StringUtils.isNotEmpty(componentVersionInfo.getVersion())) {
            output.append(" VERSION: " + componentVersionInfo.getVersion());
        }
        if (StringUtils.isNotEmpty(componentVersionInfo.getBranch())) {
            output.append(" BRANCH: " + componentVersionInfo.getBranch());
        }
        if (StringUtils.isNotEmpty(componentVersionInfo.getRevision())) {
            output.append(" REVISION: " + componentVersionInfo.getRevision());
        }
        if (StringUtils.isNotEmpty(componentVersionInfo.getBuildTimeString())) {
            output.append(" BUILT AT: " + componentVersionInfo.getBuildTimeString());
        }
    }

    private static void getHtmlOutput(StringBuilder output, Collection<ComponentVersionInfo> warReports, Collection<ComponentVersionInfo> jarReports, StringBuilder log) {
        ComponentVersionReportTool.getHtmlHeaderOutput(output, log);
        if (!warReports.isEmpty()) {
            ComponentVersionReportTool.getAppTableHtmlHeaderOutput(output, "web");
            for (ComponentVersionInfo cvi : warReports) {
                ComponentVersionReportTool.getHtmlAppTableRow(output, cvi);
                for (ComponentVersionInfo depInfo : cvi.getDependencies()) {
                    ComponentVersionReportTool.getHtmlAppTableRow(output, depInfo);
                }
            }
            output.append("</table>");
        }
        if (!jarReports.isEmpty()) {
            ComponentVersionReportTool.getAppTableHtmlHeaderOutput(output, "java");
            for (ComponentVersionInfo cvi : jarReports) {
                ComponentVersionReportTool.getHtmlAppTableRow(output, cvi);
                for (ComponentVersionInfo depInfo : cvi.getDependencies()) {
                    ComponentVersionReportTool.getHtmlAppTableRow(output, depInfo);
                }
            }
            output.append("</table>");
        }
        output.append("</body></html>");
    }

    private static void getHtmlHeaderOutput(StringBuilder output, StringBuilder log) {
        SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm");
        output.append("<!doctype html><html><head>");
        output.append("<style type=\"text/css\">");
        output.append("body { background-color:WhiteSmoke; }");
        output.append("table { border-collapse:collapse; border:1px solid black }");
        output.append("tr.component {background-color:YellowGreen}");
        output.append("tr.dependency {background-color:white}");
        output.append("tr.spacer {background-color:LightGray}");
        output.append("th { padding:10px }");
        output.append("td { padding-left:10px; padding-right:10px; padding-top:10px; border-top: 1px solid black; }");
        output.append("</style>");
        output.append("<title>DataONE Coordinating Components</title>");
        output.append("</head><body>");
        output.append("<p>Version report created at " + format.format(new Date(System.currentTimeMillis())) + ".</p>");
        output.append("<p>" + log.toString() + "</p>");
    }

    private static void getAppTableHtmlHeaderOutput(StringBuilder output, String appType) {
        output.append("<p>DataONE CN Node " + appType + " applications: </p></br>");
        output.append("<table><tr><th>App Name</th><th>Dep Name/Path</th><th>Version</th><th>Build Time</th><th>Source Branch</th><th>Revision</th></tr>");
    }

    private static void getHtmlAppTableRow(StringBuilder output, ComponentVersionInfo cvi) {
        if (cvi.isMainComponent()) {
            output.append("<tr class='component'>");
            output.append("<td>" + cvi.getName() + "</td>");
            output.append("<td width=\"300px\" style=\"word-wrap:break-word;\"><div style=\"width:280px;overflow:auto\">" + cvi.getPath() + "</div></td>");
        } else {
            output.append("<tr class='dependency'>");
            output.append("<td></td><td>" + cvi.getName() + "</td>");
        }
        output.append("<td>" + cvi.getVersion() + "</td>");
        output.append("<td>" + cvi.getBuildTimeString() + "</td>");
        output.append("<td>" + cvi.getBranch() + "</td>");
        output.append("<td>" + cvi.getRevision() + "</td></tr>");
        if (cvi.isDependent()) {
            if (!"".equals(cvi.getPath())) {
                output.append("<tr class='dependency'><td></td><td colspan='5'>" + cvi.getPath() + "</td></tr>");
            }
            output.append("<tr class='spacer'><td colspan='6'>&nbsp;</td></tr>");
        }
    }
}

