/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.bookkeeper.jdbi;

import java.util.List;
import org.dataone.bookkeeper.api.Quota;
import org.jdbi.v3.sqlobject.config.RegisterBeanMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.BindList;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

@RegisterBeanMapper(value=Quota.class)
public interface QuotaStore {
    public static final String SELECT_CLAUSE = "SELECT q.id, q.object, q.quotaType, q.softLimit, q.hardLimit, q.totalUsage, q.unit, q.orderId, q.subject, q.name FROM quotas q ";
    public static final String SELECT_ALL = "SELECT q.id, q.object, q.quotaType, q.softLimit, q.hardLimit, q.totalUsage, q.unit, q.orderId, q.subject, q.name FROM quotas q ";
    public static final String SELECT_UNASSIGNED = "SELECT q.id, q.object, q.quotaType, q.softLimit, q.hardLimit, q.totalUsage, q.unit, q.orderId, q.subject, q.name FROM quotas q WHERE orderId IS NULL ";
    public static final String SELECT_ONE = "SELECT q.id, q.object, q.quotaType, q.softLimit, q.hardLimit, q.totalUsage, q.unit, q.orderId, q.subject, q.name FROM quotas q WHERE q.id = :id ";
    public static final String SELECT_BY_TYPE = "SELECT q.id, q.object, q.quotaType, q.softLimit, q.hardLimit, q.totalUsage, q.unit, q.orderId, q.subject, q.name FROM quotas q WHERE q.quotaType = :quotaType";
    public static final String SELECT_ORDER = "SELECT q.id, q.object, q.quotaType, q.softLimit, q.hardLimit, q.totalUsage, q.unit, q.orderId, q.subject, q.name FROM quotas q WHERE q.orderId = :orderId ";
    public static final String SELECT_OWNER = "SELECT q.id, q.object, q.quotaType, q.softLimit, q.hardLimit, q.totalUsage, q.unit, q.orderId, q.subject, q.name FROM quotas q WHERE q.subject = :subject ";
    public static final String SELECT_OWNERS = "SELECT q.id, q.object, q.quotaType, q.softLimit, q.hardLimit, q.totalUsage, q.unit, q.orderId, q.subject, q.name FROM quotas q WHERE q.subject IN (<subjects>) ";
    public static final String SELECT_BY_NAME_AND_OWNERS = "SELECT q.id, q.object, q.quotaType, q.softLimit, q.hardLimit, q.totalUsage, q.unit, q.orderId, q.subject, q.name FROM quotas q WHERE q.quotaType = :quotaType AND q.subject IN (<subjects>) ";

    @SqlQuery(value="SELECT q.id, q.object, q.quotaType, q.softLimit, q.hardLimit, q.totalUsage, q.unit, q.orderId, q.subject, q.name FROM quotas q ")
    public List<Quota> listQuotas();

    @SqlQuery(value="SELECT q.id, q.object, q.quotaType, q.softLimit, q.hardLimit, q.totalUsage, q.unit, q.orderId, q.subject, q.name FROM quotas q WHERE orderId IS NULL ")
    public List<Quota> listUnassignedQuotas();

    @SqlQuery(value="SELECT q.id, q.object, q.quotaType, q.softLimit, q.hardLimit, q.totalUsage, q.unit, q.orderId, q.subject, q.name FROM quotas q WHERE q.id = :id ")
    public Quota getQuota(@Bind(value="id") Integer var1);

    @SqlQuery(value="SELECT q.id, q.object, q.quotaType, q.softLimit, q.hardLimit, q.totalUsage, q.unit, q.orderId, q.subject, q.name FROM quotas q WHERE q.orderId = :orderId ")
    public List<Quota> findQuotasByOrderId(@Bind(value="orderId") Integer var1);

    @SqlQuery(value="SELECT q.id, q.object, q.quotaType, q.softLimit, q.hardLimit, q.totalUsage, q.unit, q.orderId, q.subject, q.name FROM quotas q WHERE q.quotaType = :quotaType")
    public List<Quota> findQuotasByType(@Bind(value="quotaType") String var1);

    @SqlQuery(value="SELECT q.id, q.object, q.quotaType, q.softLimit, q.hardLimit, q.totalUsage, q.unit, q.orderId, q.subject, q.name FROM quotas q WHERE q.subject = :subject ")
    public List<Quota> findQuotasBySubject(@Bind(value="subject") String var1);

    @SqlQuery(value="SELECT q.id, q.object, q.quotaType, q.softLimit, q.hardLimit, q.totalUsage, q.unit, q.orderId, q.subject, q.name FROM quotas q WHERE q.subject IN (<subjects>) ")
    public List<Quota> findQuotasBySubjects(@BindList(value="subjects") List<String> var1);

    @SqlQuery(value="SELECT q.id, q.object, q.quotaType, q.softLimit, q.hardLimit, q.totalUsage, q.unit, q.orderId, q.subject, q.name FROM quotas q WHERE q.quotaType = :quotaType AND q.subject IN (<subjects>) ")
    public List<Quota> findQuotasByNameAndSubjects(@Bind(value="quotaType") String var1, @BindList(value="subjects") List<String> var2);

    @SqlUpdate(value="INSERT INTO quotas (object, quotaType, softLimit, hardLimit, unit, orderId, subject, name) VALUES (:object, :quotaType, :softLimit, :hardLimit, :unit, :orderId, :subject, :name) RETURNING id")
    @GetGeneratedKeys
    public Integer insert(@BindBean Quota var1);

    @SqlUpdate(value="UPDATE quotas SET object = :object, quotaType = :quotaType, softLimit = :softLimit, hardLimit = :hardLimit, unit = :unit, orderId = :orderId, subject = :subject, name = :name WHERE id = :id ")
    @GetGeneratedKeys
    public Quota update(@BindBean Quota var1);

    @SqlUpdate(value="DELETE FROM quotas WHERE id = :id")
    public void delete(@Bind(value="id") Integer var1);
}

