/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.bookkeeper.jdbi;

import java.util.List;
import org.dataone.bookkeeper.api.Order;
import org.dataone.bookkeeper.api.Quota;
import org.dataone.bookkeeper.jdbi.OrderQuotasReducer;
import org.dataone.bookkeeper.jdbi.mappers.OrderMapper;
import org.jdbi.v3.sqlobject.config.RegisterBeanMapper;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindList;
import org.jdbi.v3.sqlobject.customizer.BindMethods;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.sqlobject.statement.UseRowReducer;

public interface OrderStore {
    public static final String SELECT_CLAUSE = "SELECT o.id AS o_id, o.object AS o_object, o.amount AS o_amount, o.amountReturned AS o_amountReturned, o.charge::json AS o_charge, date_part('epoch', o.created)::int AS o_created, o.currency AS o_currency, o.customer AS o_customer, o.subject AS o_subject, o.email AS o_email, o.items::json AS o_items, o.metadata::json AS o_metadata, o.name AS o_name, o.status AS o_status, o.statusTransitions::json AS o_statusTransitions, date_part('epoch', o.updated)::int AS o_updated, o.seriesId AS o_seriesId, date_part('epoch', o.startDate)::int AS o_startDate, date_part('epoch', o.endDate)::int AS o_endDate, q.id AS q_id, q.object AS q_object, q.quotaType AS q_quotaType, q.softLimit AS q_softLimit, q.hardLimit AS q_hardLimit, q.totalUsage AS q_totalUsage, q.unit AS q_unit, q.orderId AS q_orderId, q.subject AS q_subject, q.name AS q_name FROM orders o LEFT JOIN quotas q ON q.orderId = o.id ";
    public static final String ORDER_CLAUSE = "ORDER BY o.id, o.created, o.updated ";
    public static final String SELECT_ALL = "SELECT o.id AS o_id, o.object AS o_object, o.amount AS o_amount, o.amountReturned AS o_amountReturned, o.charge::json AS o_charge, date_part('epoch', o.created)::int AS o_created, o.currency AS o_currency, o.customer AS o_customer, o.subject AS o_subject, o.email AS o_email, o.items::json AS o_items, o.metadata::json AS o_metadata, o.name AS o_name, o.status AS o_status, o.statusTransitions::json AS o_statusTransitions, date_part('epoch', o.updated)::int AS o_updated, o.seriesId AS o_seriesId, date_part('epoch', o.startDate)::int AS o_startDate, date_part('epoch', o.endDate)::int AS o_endDate, q.id AS q_id, q.object AS q_object, q.quotaType AS q_quotaType, q.softLimit AS q_softLimit, q.hardLimit AS q_hardLimit, q.totalUsage AS q_totalUsage, q.unit AS q_unit, q.orderId AS q_orderId, q.subject AS q_subject, q.name AS q_name FROM orders o LEFT JOIN quotas q ON q.orderId = o.id ORDER BY o.id, o.created, o.updated ";
    public static final String SELECT_ONE = "SELECT o.id AS o_id, o.object AS o_object, o.amount AS o_amount, o.amountReturned AS o_amountReturned, o.charge::json AS o_charge, date_part('epoch', o.created)::int AS o_created, o.currency AS o_currency, o.customer AS o_customer, o.subject AS o_subject, o.email AS o_email, o.items::json AS o_items, o.metadata::json AS o_metadata, o.name AS o_name, o.status AS o_status, o.statusTransitions::json AS o_statusTransitions, date_part('epoch', o.updated)::int AS o_updated, o.seriesId AS o_seriesId, date_part('epoch', o.startDate)::int AS o_startDate, date_part('epoch', o.endDate)::int AS o_endDate, q.id AS q_id, q.object AS q_object, q.quotaType AS q_quotaType, q.softLimit AS q_softLimit, q.hardLimit AS q_hardLimit, q.totalUsage AS q_totalUsage, q.unit AS q_unit, q.orderId AS q_orderId, q.subject AS q_subject, q.name AS q_name FROM orders o LEFT JOIN quotas q ON q.orderId = o.id WHERE o.id = :id ";
    public static final String SELECT_CUSTOMER = "SELECT o.id AS o_id, o.object AS o_object, o.amount AS o_amount, o.amountReturned AS o_amountReturned, o.charge::json AS o_charge, date_part('epoch', o.created)::int AS o_created, o.currency AS o_currency, o.customer AS o_customer, o.subject AS o_subject, o.email AS o_email, o.items::json AS o_items, o.metadata::json AS o_metadata, o.name AS o_name, o.status AS o_status, o.statusTransitions::json AS o_statusTransitions, date_part('epoch', o.updated)::int AS o_updated, o.seriesId AS o_seriesId, date_part('epoch', o.startDate)::int AS o_startDate, date_part('epoch', o.endDate)::int AS o_endDate, q.id AS q_id, q.object AS q_object, q.quotaType AS q_quotaType, q.softLimit AS q_softLimit, q.hardLimit AS q_hardLimit, q.totalUsage AS q_totalUsage, q.unit AS q_unit, q.orderId AS q_orderId, q.subject AS q_subject, q.name AS q_name FROM orders o LEFT JOIN quotas q ON q.orderId = o.id WHERE customer = :customer ";
    public static final String SELECT_SUBJECTS = "SELECT o.id AS o_id, o.object AS o_object, o.amount AS o_amount, o.amountReturned AS o_amountReturned, o.charge::json AS o_charge, date_part('epoch', o.created)::int AS o_created, o.currency AS o_currency, o.customer AS o_customer, o.subject AS o_subject, o.email AS o_email, o.items::json AS o_items, o.metadata::json AS o_metadata, o.name AS o_name, o.status AS o_status, o.statusTransitions::json AS o_statusTransitions, date_part('epoch', o.updated)::int AS o_updated, o.seriesId AS o_seriesId, date_part('epoch', o.startDate)::int AS o_startDate, date_part('epoch', o.endDate)::int AS o_endDate, q.id AS q_id, q.object AS q_object, q.quotaType AS q_quotaType, q.softLimit AS q_softLimit, q.hardLimit AS q_hardLimit, q.totalUsage AS q_totalUsage, q.unit AS q_unit, q.orderId AS q_orderId, q.subject AS q_subject, q.name AS q_name FROM orders o LEFT JOIN quotas q ON q.orderId = o.id WHERE o.subject IN (<subjects>) ORDER BY o.id, o.created, o.updated ";

    @SqlQuery(value="SELECT o.id AS o_id, o.object AS o_object, o.amount AS o_amount, o.amountReturned AS o_amountReturned, o.charge::json AS o_charge, date_part('epoch', o.created)::int AS o_created, o.currency AS o_currency, o.customer AS o_customer, o.subject AS o_subject, o.email AS o_email, o.items::json AS o_items, o.metadata::json AS o_metadata, o.name AS o_name, o.status AS o_status, o.statusTransitions::json AS o_statusTransitions, date_part('epoch', o.updated)::int AS o_updated, o.seriesId AS o_seriesId, date_part('epoch', o.startDate)::int AS o_startDate, date_part('epoch', o.endDate)::int AS o_endDate, q.id AS q_id, q.object AS q_object, q.quotaType AS q_quotaType, q.softLimit AS q_softLimit, q.hardLimit AS q_hardLimit, q.totalUsage AS q_totalUsage, q.unit AS q_unit, q.orderId AS q_orderId, q.subject AS q_subject, q.name AS q_name FROM orders o LEFT JOIN quotas q ON q.orderId = o.id ORDER BY o.id, o.created, o.updated ")
    @RegisterBeanMapper(value=Quota.class, prefix="q")
    @RegisterRowMapper(value=OrderMapper.class)
    @UseRowReducer(value=OrderQuotasReducer.class)
    public List<Order> listOrders();

    @SqlQuery(value="SELECT o.id AS o_id, o.object AS o_object, o.amount AS o_amount, o.amountReturned AS o_amountReturned, o.charge::json AS o_charge, date_part('epoch', o.created)::int AS o_created, o.currency AS o_currency, o.customer AS o_customer, o.subject AS o_subject, o.email AS o_email, o.items::json AS o_items, o.metadata::json AS o_metadata, o.name AS o_name, o.status AS o_status, o.statusTransitions::json AS o_statusTransitions, date_part('epoch', o.updated)::int AS o_updated, o.seriesId AS o_seriesId, date_part('epoch', o.startDate)::int AS o_startDate, date_part('epoch', o.endDate)::int AS o_endDate, q.id AS q_id, q.object AS q_object, q.quotaType AS q_quotaType, q.softLimit AS q_softLimit, q.hardLimit AS q_hardLimit, q.totalUsage AS q_totalUsage, q.unit AS q_unit, q.orderId AS q_orderId, q.subject AS q_subject, q.name AS q_name FROM orders o LEFT JOIN quotas q ON q.orderId = o.id WHERE o.id = :id ")
    @RegisterBeanMapper(value=Quota.class, prefix="q")
    @RegisterRowMapper(value=OrderMapper.class)
    @UseRowReducer(value=OrderQuotasReducer.class)
    public Order getOrder(@Bind(value="id") Integer var1);

    @SqlQuery(value="SELECT o.id AS o_id, o.object AS o_object, o.amount AS o_amount, o.amountReturned AS o_amountReturned, o.charge::json AS o_charge, date_part('epoch', o.created)::int AS o_created, o.currency AS o_currency, o.customer AS o_customer, o.subject AS o_subject, o.email AS o_email, o.items::json AS o_items, o.metadata::json AS o_metadata, o.name AS o_name, o.status AS o_status, o.statusTransitions::json AS o_statusTransitions, date_part('epoch', o.updated)::int AS o_updated, o.seriesId AS o_seriesId, date_part('epoch', o.startDate)::int AS o_startDate, date_part('epoch', o.endDate)::int AS o_endDate, q.id AS q_id, q.object AS q_object, q.quotaType AS q_quotaType, q.softLimit AS q_softLimit, q.hardLimit AS q_hardLimit, q.totalUsage AS q_totalUsage, q.unit AS q_unit, q.orderId AS q_orderId, q.subject AS q_subject, q.name AS q_name FROM orders o LEFT JOIN quotas q ON q.orderId = o.id WHERE customer = :customer ")
    @RegisterBeanMapper(value=Quota.class, prefix="q")
    @RegisterRowMapper(value=OrderMapper.class)
    @UseRowReducer(value=OrderQuotasReducer.class)
    public List<Order> findOrdersByCustomerId(@Bind(value="customer") Integer var1);

    @SqlQuery(value="SELECT o.id AS o_id, o.object AS o_object, o.amount AS o_amount, o.amountReturned AS o_amountReturned, o.charge::json AS o_charge, date_part('epoch', o.created)::int AS o_created, o.currency AS o_currency, o.customer AS o_customer, o.subject AS o_subject, o.email AS o_email, o.items::json AS o_items, o.metadata::json AS o_metadata, o.name AS o_name, o.status AS o_status, o.statusTransitions::json AS o_statusTransitions, date_part('epoch', o.updated)::int AS o_updated, o.seriesId AS o_seriesId, date_part('epoch', o.startDate)::int AS o_startDate, date_part('epoch', o.endDate)::int AS o_endDate, q.id AS q_id, q.object AS q_object, q.quotaType AS q_quotaType, q.softLimit AS q_softLimit, q.hardLimit AS q_hardLimit, q.totalUsage AS q_totalUsage, q.unit AS q_unit, q.orderId AS q_orderId, q.subject AS q_subject, q.name AS q_name FROM orders o LEFT JOIN quotas q ON q.orderId = o.id WHERE o.subject IN (<subjects>) ORDER BY o.id, o.created, o.updated ")
    @RegisterBeanMapper(value=Quota.class, prefix="q")
    @RegisterRowMapper(value=OrderMapper.class)
    @UseRowReducer(value=OrderQuotasReducer.class)
    public List<Order> findOrdersBySubjects(@BindList(value="subjects") List<String> var1);

    @SqlUpdate(value="INSERT INTO orders (object, amount, amountReturned, charge, created, currency, customer, subject, email, items, metadata, name, status, statusTransitions, updated, seriesId, startDate, endDate ) VALUES (:getObject, :getAmount, :getAmountReturned, :getChargeJSON::json, to_timestamp(:getCreated), :getCurrency, :getCustomer, :getSubject, :getEmail, :getItemsJSON::json, :getMetadataJSON::json, :getName, :getStatus, :getStatusTransitionsJSON::json, to_timestamp(:getUpdated), :getSeriesId, to_timestamp(:getStartDate), to_timestamp(:getEndDate)) RETURNING id")
    @GetGeneratedKeys
    public Integer insert(@BindMethods Order var1);

    @SqlUpdate(value="UPDATE orders SET object = :getObject, amount = :getAmount, amountReturned = :getAmountReturned, charge = :getChargeJSON::json, created = to_timestamp(:getCreated), currency = :getCurrency, customer = :getCustomer, subject = :getSubject, email = :getEmail, items = :getItemsJSON::json, metadata = :getMetadataJSON::json, name = :getName, status = :getStatus, statusTransitions = :getStatusTransitionsJSON::json, updated = to_timestamp(:getUpdated), seriesId = :getSeriesId, startDate = to_timestamp(:getStartDate), endDate = to_timestamp(:getEndDate) WHERE id = :getId RETURNING id")
    @GetGeneratedKeys
    public Integer update(@BindMethods Order var1);

    @SqlUpdate(value="DELETE FROM orders WHERE id = :id")
    public void delete(@Bind(value="id") Integer var1);
}

