/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.datamanager.database;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ecoinformatics.datamanager.database.DataNotMatchingMetadataException;
import org.ecoinformatics.datamanager.parser.Attribute;
import org.ecoinformatics.datamanager.parser.AttributeList;
import org.ecoinformatics.datamanager.parser.DateTimeDomain;
import org.ecoinformatics.datamanager.parser.Domain;
import org.ecoinformatics.datamanager.parser.StorageType;

public abstract class DatabaseAdapter {
    public static Log log = LogFactory.getLog(DatabaseAdapter.class);
    public static final String HSQL_ADAPTER = "HSQLAdapter";
    public static final String ORACLE_ADAPTER = "OracleAdapter";
    public static final String POSTGRES_ADAPTER = "PostgresAdapter";
    public static final String COMMA = ",";
    public static final String SPACE = " ";
    public static final String INSERT = "INSERT INTO";
    public static final String LEFTPARENTH = "(";
    public static final String RIGHTPARENTH = ")";
    public static final String SEMICOLON = ";";
    public static final String DOUBLEQUOTE = "\"";
    public static final String SINGLEQUOTE = "'";
    public static final String VALUES = "VALUES";
    public static final String NULL = "null";
    public static final String UNDERSCORE = "_";
    protected String TO_DATE_FUNCTION = "to_timestamp";
    private final String XML_SCHEMA_DATATYPES = "http://www.w3.org/2001/XMLSchema-datatypes";
    protected static final int DEFAULT_TABLE_NAME_MAX_LENGTH = 30;

    public static int getTableNameMaxLength() {
        return 30;
    }

    public static String getLegalDBTableName(String entityName) {
        int tableNameMaxLength = DatabaseAdapter.getTableNameMaxLength();
        String legalName = null;
        char[] badChars = new char[]{' ', '-', '.', '/', ',', '(', ')', '<', '>'};
        char goodChar = '_';
        if (entityName != null) {
            int entityNameLength = entityName.length();
            int legalNameLength = Math.min(entityNameLength, tableNameMaxLength);
            legalName = entityName.substring(0, legalNameLength);
        }
        if (legalName != null) {
            for (int i = 0; i < badChars.length; ++i) {
                legalName = legalName.replace(badChars[i], goodChar);
            }
            char firstCharacter = legalName.charAt(0);
            if (Character.isDigit(firstCharacter)) {
                legalName = UNDERSCORE + legalName;
            }
        }
        return legalName;
    }

    public void assignDbFieldNames(AttributeList attributeList) {
        Attribute[] list = attributeList.getAttributes();
        TreeMap<String, String> usedNames = new TreeMap<String, String>();
        for (Attribute attribute : list) {
            String attributeName = attribute.getName();
            String legalDbFieldName = this.getLegalDbFieldName(attributeName);
            String foundName = (String)usedNames.get(legalDbFieldName);
            while (foundName != null) {
                String mangledName;
                legalDbFieldName = mangledName = this.mangleFieldName(legalDbFieldName);
                foundName = (String)usedNames.get(legalDbFieldName);
            }
            usedNames.put(legalDbFieldName, legalDbFieldName);
            String quotedName = DOUBLEQUOTE + legalDbFieldName + DOUBLEQUOTE;
            attribute.setDBFieldName(quotedName);
        }
    }

    public String generateDDL(AttributeList attributeList, String tableName) throws SQLException {
        String ddlString = "";
        return ddlString;
    }

    public String generateDropTableSQL(String tableName) {
        String sqlString = "";
        return sqlString;
    }

    public String generateInsertSQL(AttributeList attributeList, String tableName, Vector oneRowData) throws DataNotMatchingMetadataException, SQLException {
        String sqlString = null;
        int NULLValueCounter = 0;
        int hasValueCounter = 0;
        if (attributeList == null) {
            throw new SQLException("The attribute list is null and couldn't generate insert sql statement");
        }
        if (oneRowData == null || oneRowData.isEmpty()) {
            throw new SQLException("The the data is null and couldn't generte insert sql statement");
        }
        StringBuffer sqlAttributePart = new StringBuffer();
        StringBuffer sqlDataPart = new StringBuffer();
        sqlAttributePart.append(INSERT);
        sqlAttributePart.append(SPACE);
        sqlAttributePart.append(tableName);
        sqlAttributePart.append(LEFTPARENTH);
        sqlDataPart.append(SPACE);
        sqlDataPart.append(VALUES);
        sqlDataPart.append(SPACE);
        sqlDataPart.append(LEFTPARENTH);
        Attribute[] list = attributeList.getAttributes();
        if (list == null || list.length == 0) {
            throw new SQLException("The attributes is null and couldn't generate insert sql statement");
        }
        int size = list.length;
        boolean firstAttribute = true;
        for (int i = 0; i < size; ++i) {
            Object obj = oneRowData.elementAt(i);
            String value = null;
            if (obj == null) {
                ++NULLValueCounter;
                continue;
            }
            value = (String)obj;
            if (value.trim().equals("")) continue;
            Attribute attribute = list[i];
            if (attribute == null) {
                throw new SQLException("Attribute list contains a null attribute");
            }
            String[] missingValues = attribute.getMissingValueCode();
            boolean isMissingValue = this.isMissingValue(value, missingValues);
            if (isMissingValue) continue;
            String name = attribute.getDBFieldName();
            String attributeType = this.getAttributeType(attribute);
            if (!firstAttribute) {
                sqlAttributePart.append(COMMA);
                sqlDataPart.append(COMMA);
            }
            sqlAttributePart.append(name);
            Domain domain = attribute.getDomain();
            if (attributeType.equalsIgnoreCase("datetime")) {
                String formatString = ((DateTimeDomain)domain).getFormatString();
                formatString = this.transformFormatString(formatString);
                value = this.transformDatetime(value);
                value = this.escapeSpecialCharacterInData(value);
                sqlDataPart.append(this.TO_DATE_FUNCTION);
                sqlDataPart.append(LEFTPARENTH);
                sqlDataPart.append(SINGLEQUOTE);
                sqlDataPart.append(value);
                sqlDataPart.append(SINGLEQUOTE);
                sqlDataPart.append(COMMA);
                sqlDataPart.append(SINGLEQUOTE);
                sqlDataPart.append(formatString);
                sqlDataPart.append(SINGLEQUOTE);
                sqlDataPart.append(RIGHTPARENTH);
                ++hasValueCounter;
                log.debug((Object)("datetime value expression= " + sqlDataPart.toString()));
            } else if (attributeType.equals("string")) {
                value = this.escapeSpecialCharacterInData(value);
                sqlDataPart.append(SINGLEQUOTE);
                sqlDataPart.append(value);
                sqlDataPart.append(SINGLEQUOTE);
                ++hasValueCounter;
            } else {
                String dataType = this.mapDataType(attributeType);
                try {
                    if (dataType.equals("FLOAT")) {
                        Float floatObj = new Float(value);
                        float floatNum = floatObj.floatValue();
                        sqlDataPart.append(floatNum);
                    } else {
                        Integer integerObj = new Integer(value);
                        int integerNum = integerObj;
                        sqlDataPart.append(integerNum);
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Error determining numeric value: " + e.getMessage()));
                    throw new DataNotMatchingMetadataException("Data value '" + value + "' is NOT the expected data type of '" + dataType + SINGLEQUOTE);
                }
                ++hasValueCounter;
            }
            firstAttribute = false;
        }
        if (NULLValueCounter == list.length || hasValueCounter == 0) {
            return sqlString;
        }
        sqlAttributePart.append(RIGHTPARENTH);
        sqlDataPart.append(RIGHTPARENTH);
        sqlDataPart.append(SEMICOLON);
        sqlAttributePart.append(sqlDataPart.toString());
        sqlString = sqlAttributePart.toString();
        return sqlString;
    }

    protected abstract String getAttributeType(Attribute var1);

    protected String getAttributeTypeFromStorageType(Attribute attribute, String className) {
        String attributeType = null;
        if (attribute != null) {
            ArrayList<StorageType> storageTypes = attribute.getStorageTypeArray();
            for (StorageType storageType : storageTypes) {
                String typeSystem;
                String textValue;
                if (storageType == null || (textValue = storageType.getTextValue()) == null || textValue.equals("") || (typeSystem = storageType.getTypeSystem()) == null || typeSystem.equals("")) continue;
                if (typeSystem.equals("http://www.w3.org/2001/XMLSchema-datatypes")) {
                    attributeType = textValue.equalsIgnoreCase("string") ? "string" : (textValue.equalsIgnoreCase("int") || textValue.equalsIgnoreCase("long") || textValue.equalsIgnoreCase("short") || textValue.equalsIgnoreCase("integer") ? "integer" : (textValue.equalsIgnoreCase("float") || textValue.equalsIgnoreCase("double") ? "real" : (textValue.equalsIgnoreCase("date") || textValue.equalsIgnoreCase("datetime") ? "datetime" : "string")));
                    return attributeType;
                }
                if (!textValue.equalsIgnoreCase("integer") && !textValue.equalsIgnoreCase("datetime") && !textValue.equalsIgnoreCase("natural") && !textValue.equalsIgnoreCase("string") && !textValue.equalsIgnoreCase("real") && !textValue.equalsIgnoreCase("whole")) continue;
                attributeType = textValue.toLowerCase();
            }
        }
        return attributeType;
    }

    public abstract String getCountingRowNumberSQL(String var1);

    public Map getDataTypeMap() {
        Map typeMap = null;
        return typeMap;
    }

    private String getLegalDbFieldName(String attributeName) {
        String legalName = attributeName;
        char[] badChars = new char[]{' ', '-', '.', '/', ':', '@', '[', ']'};
        char goodChar = '_';
        for (int i = 0; i < badChars.length; ++i) {
            legalName = legalName.replace(badChars[i], goodChar);
        }
        return legalName;
    }

    private boolean isMissingValue(String value, String[] missValues) {
        boolean isMissingValue = false;
        if (missValues != null && value != null) {
            for (String missValue : missValues) {
                if (!value.equals(missValue)) continue;
                isMissingValue = true;
                break;
            }
        }
        return isMissingValue;
    }

    private String mangleFieldName(String originalName) {
        StringBuffer stringBuffer = new StringBuffer(originalName);
        stringBuffer.append("_Prime");
        return stringBuffer.toString();
    }

    protected abstract String mapDataType(String var1);

    protected String parseAttributeList(AttributeList attributeList) throws SQLException {
        Attribute[] list = attributeList.getAttributes();
        StringBuffer attributeSql = new StringBuffer();
        if (list == null || list.length == 0) {
            throw new SQLException("No attribute definition found in entity");
        }
        this.assignDbFieldNames(attributeList);
        int size = list.length;
        boolean firstAttribute = true;
        for (int i = 0; i < size; ++i) {
            Attribute attribute = list[i];
            if (attribute == null) {
                throw new SQLException("Attribute list contains a null attribute");
            }
            String attributeName = attribute.getName();
            String fieldName = attribute.getDBFieldName();
            String attributeType = this.getAttributeType(attribute);
            String dbDataType = this.mapDataType(attributeType);
            if (!firstAttribute) {
                attributeSql.append(COMMA);
            }
            attributeSql.append(fieldName);
            attributeSql.append(SPACE);
            attributeSql.append(dbDataType);
            firstAttribute = false;
            log.debug((Object)("Attribute Name: " + attributeName));
            log.debug((Object)("DB Field Name : " + fieldName));
            log.debug((Object)("dbDataType    : " + dbDataType + "\n"));
        }
        return attributeSql.toString();
    }

    protected String transformDatetime(String datetimeString) {
        return datetimeString;
    }

    protected String transformFormatString(String emlFormatString) {
        return emlFormatString;
    }

    public String transformSelectionSQL(String ANSISQL) {
        String sqlString = "";
        return sqlString;
    }

    protected String escapeSpecialCharacterInData(String data) {
        String[] specialArray = new String[]{SINGLEQUOTE};
        String escape = SINGLEQUOTE;
        if (data == null) {
            return data;
        }
        for (String special : specialArray) {
            if (!data.contains(special)) continue;
            data = data.replaceAll(special, escape + special);
        }
        return data;
    }
}

