/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.bookkeeper.jdbi;

import java.util.List;
import org.dataone.bookkeeper.api.Product;
import org.dataone.bookkeeper.jdbi.mappers.ProductMapper;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindMethods;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.sqlobject.statement.UseRowMapper;

public interface ProductStore {
    public static final String SELECT_CLAUSE = "SELECT id, object, active, amount, caption, date_part('epoch', created)::int AS created, currency, description, interval, name, statementDescriptor, type, unitLabel, url, metadata::json AS metadata FROM products ";
    public static final String ORDER_CLAUSE = "ORDER BY name, created DESC ";
    public static final String SELECT_ALL = "SELECT id, object, active, amount, caption, date_part('epoch', created)::int AS created, currency, description, interval, name, statementDescriptor, type, unitLabel, url, metadata::json AS metadata FROM products ORDER BY name, created DESC ";
    public static final String SELECT_BY_ID = "SELECT id, object, active, amount, caption, date_part('epoch', created)::int AS created, currency, description, interval, name, statementDescriptor, type, unitLabel, url, metadata::json AS metadata FROM products WHERE id = :id ORDER BY name, created DESC ";
    public static final String SELECT_BY_NAME = "SELECT id, object, active, amount, caption, date_part('epoch', created)::int AS created, currency, description, interval, name, statementDescriptor, type, unitLabel, url, metadata::json AS metadata FROM products WHERE name = :name ORDER BY name, created DESC ";
    public static final String SELECT_BY_ACTIVE = "SELECT id, object, active, amount, caption, date_part('epoch', created)::int AS created, currency, description, interval, name, statementDescriptor, type, unitLabel, url, metadata::json AS metadata FROM products WHERE active = :active ORDER BY name, created DESC ";
    public static final String SELECT_BY_DESCRIPTION = "SELECT id, object, active, amount, caption, date_part('epoch', created)::int AS created, currency, description, interval, name, statementDescriptor, type, unitLabel, url, metadata::json AS metadata FROM products WHERE description LIKE :description ORDER BY name, created DESC ";

    @SqlQuery(value="SELECT id, object, active, amount, caption, date_part('epoch', created)::int AS created, currency, description, interval, name, statementDescriptor, type, unitLabel, url, metadata::json AS metadata FROM products ORDER BY name, created DESC ")
    @RegisterRowMapper(value=ProductMapper.class)
    @UseRowMapper(value=ProductMapper.class)
    public List<Product> listProducts();

    @SqlQuery(value="SELECT id, object, active, amount, caption, date_part('epoch', created)::int AS created, currency, description, interval, name, statementDescriptor, type, unitLabel, url, metadata::json AS metadata FROM products WHERE id = :id ORDER BY name, created DESC ")
    @RegisterRowMapper(value=ProductMapper.class)
    @UseRowMapper(value=ProductMapper.class)
    public Product getProduct(@Bind(value="id") Integer var1);

    @SqlQuery(value="SELECT id, object, active, amount, caption, date_part('epoch', created)::int AS created, currency, description, interval, name, statementDescriptor, type, unitLabel, url, metadata::json AS metadata FROM products WHERE name = :name ORDER BY name, created DESC ")
    @RegisterRowMapper(value=ProductMapper.class)
    @UseRowMapper(value=ProductMapper.class)
    public List<Product> findProductsByName(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT id, object, active, amount, caption, date_part('epoch', created)::int AS created, currency, description, interval, name, statementDescriptor, type, unitLabel, url, metadata::json AS metadata FROM products WHERE active = :active ORDER BY name, created DESC ")
    @RegisterRowMapper(value=ProductMapper.class)
    @UseRowMapper(value=ProductMapper.class)
    public List<Product> findProductsByActiveStatus(@Bind(value="active") boolean var1);

    @SqlQuery(value="SELECT id, object, active, amount, caption, date_part('epoch', created)::int AS created, currency, description, interval, name, statementDescriptor, type, unitLabel, url, metadata::json AS metadata FROM products WHERE description LIKE :description ORDER BY name, created DESC ")
    @RegisterRowMapper(value=ProductMapper.class)
    @UseRowMapper(value=ProductMapper.class)
    public List<Product> findProductsByDescription(@Bind(value="description") String var1);

    @SqlUpdate(value="INSERT INTO products (object , active, amount,caption, created, currency, description, interval, name, statementDescriptor, type, unitLabel, url, metadata ) VALUES (:getObject, :isActive, :getAmount, :getCaption, to_timestamp(:getCreated), :getCurrency, :getDescription, :getInterval, :getName, :getStatementDescriptor, :getType, :getUnitLabel, :getUrl, :getMetadataJSON::json) RETURNING id")
    @GetGeneratedKeys
    public Integer insert(@BindMethods Product var1);

    @SqlUpdate(value="UPDATE products SET object = :getObject, active = :isActive, amount = :getAmount, caption = :getCaption, created = to_timestamp(:getCreated), currency = :getCurrency, description = :getDescription, interval = :getInterval, name = :getName, statementDescriptor = :getStatementDescriptor, type = :getType, unitLabel = :getUnitLabel, url = :getUrl, metadata = :getMetadataJSON::json WHERE id = :getId RETURNING id")
    @GetGeneratedKeys
    public Integer update(@BindMethods Product var1);

    @SqlUpdate(value="DELETE FROM products WHERE id = :id")
    public void delete(@Bind(value="id") Integer var1);
}

