/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.speedbagit;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Scanner;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.dataone.speedbagit.SpeedBagException;
import org.dataone.speedbagit.SpeedBagIt;
import org.dataone.speedbagit.SpeedFile;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class SpeedBagItTest {
    @TempDir
    Path directory = Files.createTempDirectory("speedbag_tests", new FileAttribute[0]);

    private void validateBagitFile(String contents, double bagVersion) throws IOException {
        BufferedReader bufReader = new BufferedReader(new StringReader(contents));
        String line = null;
        while ((line = bufReader.readLine()) != null) {
            String[] keyPair = line.split(": ");
            if (keyPair[0].equals("BagIt-Version")) {
                Assertions.assertEquals((Object)keyPair[1], (Object)String.valueOf(bagVersion));
                continue;
            }
            if (!keyPair[0].equals("Tag-File-Character-Encoding")) continue;
            Assertions.assertEquals((Object)keyPair[1], (Object)"UTF-8");
        }
    }

    private void validateBagInfoFile(String contents, ZipFile zipFile, int dataFileCount) throws IOException {
        BufferedReader bufReader = new BufferedReader(new StringReader(contents));
        String line = null;
        while ((line = bufReader.readLine()) != null) {
            String[] keyPair = line.split(": ");
            switch (keyPair[0]) {
                case "Payload-Oxum": {
                    String[] payloadOxum = keyPair[1].split("\\.");
                    Assertions.assertEquals((Object)payloadOxum[1], (Object)String.valueOf(dataFileCount));
                    break;
                }
                case "Bagging-Date": {
                    LocalDateTime dateTime = LocalDateTime.now();
                    DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd", Locale.ENGLISH);
                    Assertions.assertEquals((Object)keyPair[1], (Object)dateFormat.format(dateTime));
                }
            }
        }
    }

    static String convertStreamToString(InputStream is) {
        Scanner s = new Scanner(is).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    @Test
    public void testCtorMetadata() throws IOException {
        double bagVersion = 1.0;
        String checksumAlgorithm = "MD5";
        SpeedBagIt bag = new SpeedBagIt(bagVersion, checksumAlgorithm);
        Assertions.assertEquals((double)bag.version, (double)bagVersion);
        Assertions.assertEquals((Object)bag.checksumAlgorithm, (Object)checksumAlgorithm);
        Assertions.assertEquals((int)bag.bagitMetadata.size(), (int)0);
    }

    public SpeedBagIt getStockBag() throws SpeedBagException, NoSuchAlgorithmException, IOException {
        double bagVersion = 1.0;
        String checksumAlgorithm = "MD5";
        HashMap bagMetadata = new HashMap();
        SpeedBagIt bag = null;
        bag = new SpeedBagIt(bagVersion, checksumAlgorithm, bagMetadata);
        String dataFile1 = "1234, 9876, 3845";
        String dataFile2 = "trees, cars, bridges";
        ByteArrayInputStream dataFile1Stream = new ByteArrayInputStream(dataFile1.getBytes(StandardCharsets.UTF_8));
        ByteArrayInputStream dataFile2Stream = new ByteArrayInputStream(dataFile2.getBytes(StandardCharsets.UTF_8));
        bag.addFile((InputStream)dataFile1Stream, "data/data_file1.csv", false);
        bag.addFile((InputStream)dataFile2Stream, "data/data_file2.csv", false);
        String fetchFile = "someURI, somePath";
        String metadataFile = "extra metadata";
        ByteArrayInputStream fetchFile1Stream = new ByteArrayInputStream(fetchFile.getBytes(StandardCharsets.UTF_8));
        ByteArrayInputStream metadataFile2Stream = new ByteArrayInputStream(metadataFile.getBytes(StandardCharsets.UTF_8));
        bag.addFile((InputStream)fetchFile1Stream, "./fetch.txt", true);
        bag.addFile((InputStream)metadataFile2Stream, "metadata/metadata.csv", true);
        return bag;
    }

    @Test
    public void testCtor() throws IOException {
        double bagVersion = 1.0;
        String checksumAlgorithm = "MD5";
        HashMap<String, String> bagMetadata = new HashMap<String, String>();
        bagMetadata.put("External-Description", "A bag used for testing.");
        bagMetadata.put("External-Identifier", "1234");
        SpeedBagIt bag = new SpeedBagIt(bagVersion, checksumAlgorithm, bagMetadata);
        Assertions.assertEquals((double)bag.version, (double)bagVersion);
        Assertions.assertEquals((Object)bag.checksumAlgorithm, (Object)checksumAlgorithm);
        Assertions.assertEquals((int)bag.bagitMetadata.size(), (int)bagMetadata.size());
    }

    @Test
    public void testGenerateBagIt() throws IOException {
        double bagVersion = 1.0;
        SpeedBagIt bag = new SpeedBagIt(bagVersion, "MD5");
        String bagitTxtFile = bag.generateBagitTxt();
        HashMap<String, String> minimumMetadata = new HashMap<String, String>();
        minimumMetadata.put("version", String.valueOf(bagVersion));
        minimumMetadata.put("Tag-File-Character-Encoding", "UTF-8");
        BufferedReader bufReader = new BufferedReader(new StringReader(bagitTxtFile));
        String line = null;
        while ((line = bufReader.readLine()) != null) {
            String[] keyPair = line.split(": ");
            String key = (String)minimumMetadata.get(keyPair[0]);
            String value = (String)minimumMetadata.get(keyPair[1]);
            Assertions.assertEquals(minimumMetadata.get(key), (Object)value);
        }
    }

    @Test
    public void testGenerateBagitTxtCustom() throws IOException {
        String bagDescription = "A test bag.";
        String externalDescription = "A bag used for testing.";
        String contactEmail = "aFakeEmail";
        String externalIdentifier = "doi:xx.xxx.xx";
        HashMap<String, String> bagMetadata = new HashMap<String, String>();
        bagMetadata.put("description", bagDescription);
        bagMetadata.put("External-Description", externalDescription);
        bagMetadata.put("Contact-Email", contactEmail);
        bagMetadata.put("External-Identifier", externalIdentifier);
        SpeedBagIt bag = new SpeedBagIt(1.0, "MD5", bagMetadata);
        String bagitTxtFile = bag.generateBagitTxt();
        BufferedReader bufReader = new BufferedReader(new StringReader(bagitTxtFile));
        String line = null;
        while ((line = bufReader.readLine()) != null) {
            String[] keyPair = line.split(": ");
            String key = (String)bagMetadata.get(keyPair[0]);
            String value = (String)bagMetadata.get(keyPair[1]);
            Assertions.assertEquals(bagMetadata.get(key), (Object)value);
        }
    }

    private void validateBagItFiles(ZipFile zipFile, double bagVersion, int dataFileCount) throws IOException {
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            InputStream fileStream = zipFile.getInputStream(entry);
            String contents = SpeedBagItTest.convertStreamToString(fileStream);
            switch (entry.getName()) {
                case "bag-info.txt": {
                    this.validateBagInfoFile(contents, zipFile, dataFileCount);
                    break;
                }
                case "bagit.txt": {
                    this.validateBagitFile(contents, bagVersion);
                }
            }
        }
    }

    @Test
    public void testEmptyBag() throws IOException {
        double bagVersion = 1.0;
        String checksumAlgorithm = "MD5";
        HashMap bagMetadata = new HashMap();
        SpeedBagIt bag = null;
        Path bagFilePath = null;
        try {
            bag = new SpeedBagIt(bagVersion, checksumAlgorithm, bagMetadata);
            Path bagPath = Paths.get(this.directory.toString() + "emptyBag.zip", new String[0]);
            bagFilePath = Files.createFile(bagPath, new FileAttribute[0]);
            FileOutputStream fos = new FileOutputStream(bagFilePath.toString());
            InputStream bagStream = bag.stream();
            IOUtils.copy((InputStream)bagStream, (OutputStream)fos);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            e.printStackTrace();
            if (bagFilePath != null) {
                Files.delete(bagFilePath);
            }
            Assertions.fail();
        }
        ZipFile zipFile = new ZipFile(bagFilePath.toString());
        this.validateBagItFiles(zipFile, bagVersion, bag.getPayloadFileCount());
        Files.delete(bagFilePath);
    }

    @Test
    public void testAddFile() throws SpeedBagException, NoSuchAlgorithmException, IOException {
        ArrayList<String> expectedDataPaths = new ArrayList<String>();
        expectedDataPaths.add("data/data_file1.csv");
        expectedDataPaths.add("data/data_file2.csv");
        ArrayList<String> expecteMetadataPaths = new ArrayList<String>();
        expecteMetadataPaths.add("./fetch.txt");
        expecteMetadataPaths.add("metadata/metadata.csv");
        SpeedBagIt bag = this.getStockBag();
        List dataFiles = bag.getDataFiles();
        assert (dataFiles.size() == 2);
        for (SpeedFile dataFile : dataFiles) {
            assert (expectedDataPaths.contains(dataFile.getPath()));
        }
        List metadataFiles = bag.getTagFiles();
        assert (metadataFiles.size() == 2);
        for (SpeedFile tagFile : metadataFiles) {
            assert (expecteMetadataPaths.contains(tagFile.getPath()));
        }
    }

    @Test
    public void testGetDataFiles() throws SpeedBagException, NoSuchAlgorithmException, IOException {
        SpeedBagIt bag = this.getStockBag();
        List dataFiles = bag.getDataFiles();
        assert (dataFiles.size() == 2);
    }

    @Test
    public void testGetTagFiles() throws SpeedBagException, NoSuchAlgorithmException, IOException {
        SpeedBagIt bag = this.getStockBag();
        List metadataFiles = bag.getTagFiles();
        assert (metadataFiles.size() == 2);
    }

    @Test
    public void testDataBagExport() {
        double bagVersion = 1.0;
        String checksumAlgorithm = "MD5";
        HashMap bagMetadata = new HashMap();
        try {
            SpeedBagIt bag = new SpeedBagIt(bagVersion, checksumAlgorithm, bagMetadata);
            String dataFile1 = "1234, 9876, 3845";
            String dataFile2 = "1234, 9876, 38";
            String dataFile3 = "1234, 9876";
            ByteArrayInputStream dataFileStream1 = new ByteArrayInputStream(dataFile1.getBytes(StandardCharsets.UTF_8));
            ByteArrayInputStream dataFileStream2 = new ByteArrayInputStream(dataFile2.getBytes(StandardCharsets.UTF_8));
            ByteArrayInputStream dataFileStream3 = new ByteArrayInputStream(dataFile3.getBytes(StandardCharsets.UTF_8));
            bag.addFile((InputStream)dataFileStream1, "data/data_file1.csv", MessageDigest.getInstance("MD5"), false);
            bag.addFile((InputStream)dataFileStream2, "data/data_file2.csv", MessageDigest.getInstance("MD5"), false);
            bag.addFile((InputStream)dataFileStream3, "data/data_file3.csv", MessageDigest.getInstance("MD5"), false);
            Path bagPath = Paths.get(this.directory.toString() + "dataBag.zip", new String[0]);
            Path bagFilePath = Files.createFile(bagPath, new FileAttribute[0]);
            FileOutputStream fos = new FileOutputStream(bagFilePath.toString());
            InputStream bagStream = bag.stream();
            IOUtils.copy((InputStream)bagStream, (OutputStream)fos);
            ZipFile zipFile = new ZipFile(bagFilePath.toString());
            this.validateBagItFiles(zipFile, bagVersion, bag.getPayloadFileCount());
            Files.delete(bagFilePath);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            Assertions.fail((Throwable)e);
        }
    }

    @Test
    public void testMetadataBagExport() {
        double bagVersion = 1.0;
        String checksumAlgorithm = "MD5";
        HashMap bagMetadata = new HashMap();
        try {
            SpeedBagIt bag = new SpeedBagIt(bagVersion, checksumAlgorithm, bagMetadata);
            String metadataFile1 = "col1: frog_counts";
            String metadataFile2 = "col2: fish_counts";
            String metadataFile3 = "col3: moss_counts";
            ByteArrayInputStream dataFileStream1 = new ByteArrayInputStream(metadataFile1.getBytes(StandardCharsets.UTF_8));
            ByteArrayInputStream dataFileStream2 = new ByteArrayInputStream(metadataFile2.getBytes(StandardCharsets.UTF_8));
            ByteArrayInputStream dataFileStream3 = new ByteArrayInputStream(metadataFile3.getBytes(StandardCharsets.UTF_8));
            bag.addFile((InputStream)dataFileStream1, "metadata/metadataFile1.csv", MessageDigest.getInstance("MD5"), true);
            bag.addFile((InputStream)dataFileStream2, "metadata/metadataFile2.csv", MessageDigest.getInstance("MD5"), true);
            bag.addFile((InputStream)dataFileStream3, "metadata/metadataFile3.csv", MessageDigest.getInstance("MD5"), true);
            Path bagPath = Paths.get(this.directory.toString() + "metadataBag.zip", new String[0]);
            Path bagFilePath = Files.createFile(bagPath, new FileAttribute[0]);
            FileOutputStream fos = new FileOutputStream(bagFilePath.toString());
            InputStream bagStream = bag.stream();
            IOUtils.copy((InputStream)bagStream, (OutputStream)fos);
            ZipFile zipFile = new ZipFile(bagFilePath.toString());
            this.validateBagItFiles(zipFile, bagVersion, bag.getPayloadFileCount());
            Files.delete(bagFilePath);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            Assertions.fail((Throwable)e);
        }
    }
}

