/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib;

public class Slot<K, V> {
    private final Slot<K, V> previous;
    private final K key;
    private final V value;
    private static final String sep = ", ";

    public Slot() {
        this(null, null, null);
    }

    public Slot(K key, V value) {
        this(key, value, null);
    }

    private Slot(K key, V value, Slot<K, V> previous) {
        this.key = key;
        this.value = value;
        this.previous = previous;
    }

    public Slot<K, V> extend(K key, V value) {
        return new Slot<K, V>(key, value, this);
    }

    public final V find(K k) {
        Slot<K, V> slot = this;
        while (slot != null) {
            if (k.equals(slot.key)) {
                return slot.value;
            }
            slot = slot.previous;
        }
        return null;
    }

    private void str(int level, StringBuilder acc) {
        if (this.key == null && this.value == null) {
            return;
        }
        if (level != 0) {
            acc.append(sep);
        }
        acc.append("(");
        acc.append(this.key.toString());
        acc.append("->");
        acc.append(this.value.toString());
        acc.append(")");
        if (this.previous != null) {
            super.str(level + 1, acc);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        this.str(0, sb);
        sb.append(" }");
        return sb.toString();
    }
}

