/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.hadoop.dedup;

import java.util.Collections;
import java.util.Iterator;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.hadoop.dedup.UpdateConflictResolver;

public final class RejectingUpdateConflictResolver
implements UpdateConflictResolver {
    @Override
    public Iterator<SolrInputDocument> orderUpdates(Text key, Iterator<SolrInputDocument> updates, Reducer.Context ctx) {
        SolrInputDocument firstUpdate = null;
        while (updates.hasNext()) {
            if (firstUpdate == null) {
                firstUpdate = updates.next();
                assert (firstUpdate != null);
                continue;
            }
            throw new IllegalArgumentException("Update conflict! Documents with the same unique key are forbidden: " + key);
        }
        assert (firstUpdate != null);
        return Collections.singletonList(firstUpdate).iterator();
    }
}

