/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.hadoop;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.Progressable;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LogMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.TieredMergePolicy;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NoLockFactory;
import org.apache.solr.hadoop.HeartBeater;
import org.apache.solr.hadoop.SolrCounters;
import org.apache.solr.hadoop.Utils;
import org.apache.solr.store.hdfs.HdfsDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeMergeOutputFormat
extends FileOutputFormat<Text, NullWritable> {
    public RecordWriter getRecordWriter(TaskAttemptContext context) throws IOException {
        Utils.getLogConfigFile(context.getConfiguration());
        Path workDir = this.getDefaultWorkFile(context, "");
        return new TreeMergeRecordWriter(context, workDir);
    }

    private static final class TreeMergeRecordWriter
    extends RecordWriter<Text, NullWritable> {
        private final Path workDir;
        private final List<Path> shards = new ArrayList<Path>();
        private final HeartBeater heartBeater;
        private final TaskAttemptContext context;
        private static final Logger LOG = LoggerFactory.getLogger(TreeMergeRecordWriter.class);

        public TreeMergeRecordWriter(TaskAttemptContext context, Path workDir) {
            this.workDir = new Path(workDir, "data/index");
            this.heartBeater = new HeartBeater((Progressable)context);
            this.context = context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(Text key, NullWritable value) {
            LOG.info("map key: {}", (Object)key);
            this.heartBeater.needHeartBeat();
            try {
                Path path = new Path(key.toString());
                this.shards.add(path);
            }
            finally {
                this.heartBeater.cancelHeartBeat();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close(TaskAttemptContext context) throws IOException {
            LOG.debug("Task " + context.getTaskAttemptID() + " merging into dstDir: " + this.workDir + ", srcDirs: " + this.shards);
            this.writeShardNumberFile(context);
            this.heartBeater.needHeartBeat();
            try {
                HdfsDirectory mergedIndex = new HdfsDirectory(this.workDir, (LockFactory)NoLockFactory.INSTANCE, context.getConfiguration());
                IndexWriterConfig writerConfig = new IndexWriterConfig(null).setOpenMode(IndexWriterConfig.OpenMode.CREATE).setUseCompoundFile(false);
                if (LOG.isDebugEnabled()) {
                    writerConfig.setInfoStream(System.out);
                }
                MergePolicy mergePolicy = writerConfig.getMergePolicy();
                LOG.debug("mergePolicy was: {}", (Object)mergePolicy);
                if (mergePolicy instanceof TieredMergePolicy) {
                    ((TieredMergePolicy)mergePolicy).setNoCFSRatio(0.0);
                } else if (mergePolicy instanceof LogMergePolicy) {
                    ((LogMergePolicy)mergePolicy).setNoCFSRatio(0.0);
                }
                LOG.info("Using mergePolicy: {}", (Object)mergePolicy);
                IndexWriter writer = new IndexWriter((Directory)mergedIndex, writerConfig);
                Directory[] indexes = new Directory[this.shards.size()];
                for (int i = 0; i < this.shards.size(); ++i) {
                    indexes[i] = new HdfsDirectory(this.shards.get(i), (LockFactory)NoLockFactory.INSTANCE, context.getConfiguration());
                }
                context.setStatus("Logically merging " + this.shards.size() + " shards into one shard");
                LOG.info("Logically merging " + this.shards.size() + " shards into one shard: " + this.workDir);
                long start = System.nanoTime();
                writer.addIndexes(indexes);
                if (LOG.isDebugEnabled()) {
                    context.getCounter(SolrCounters.class.getName(), SolrCounters.LOGICAL_TREE_MERGE_TIME.toString()).increment(System.currentTimeMillis() - start);
                }
                float secs = (float)(System.nanoTime() - start) / 3.0f;
                LOG.info("Logical merge took {} secs", (Object)Float.valueOf(secs));
                int maxSegments = context.getConfiguration().getInt("maxSegmentsOnTreeMerge", Integer.MAX_VALUE);
                context.setStatus("Optimizing Solr: forcing mtree merge down to " + maxSegments + " segments");
                LOG.info("Optimizing Solr: forcing tree merge down to {} segments", (Object)maxSegments);
                start = System.nanoTime();
                if (maxSegments < Integer.MAX_VALUE) {
                    writer.forceMerge(maxSegments);
                }
                if (LOG.isDebugEnabled()) {
                    context.getCounter(SolrCounters.class.getName(), SolrCounters.PHYSICAL_TREE_MERGE_TIME.toString()).increment(System.currentTimeMillis() - start);
                }
                secs = (float)(System.nanoTime() - start) / 3.0f;
                LOG.info("Optimizing Solr: done forcing tree merge down to {} segments in {} secs", (Object)maxSegments, (Object)Float.valueOf(secs));
                start = System.nanoTime();
                LOG.info("Optimizing Solr: Closing index writer");
                writer.close();
                secs = (float)(System.nanoTime() - start) / 3.0f;
                LOG.info("Optimizing Solr: Done closing index writer in {} secs", (Object)Float.valueOf(secs));
                context.setStatus("Done");
            }
            finally {
                this.heartBeater.cancelHeartBeat();
                this.heartBeater.close();
            }
        }

        private void writeShardNumberFile(TaskAttemptContext context) throws IOException {
            Preconditions.checkArgument((this.shards.size() > 0 ? 1 : 0) != 0);
            String shard = this.shards.get(0).getParent().getParent().getName();
            String taskId = shard.substring("part-m-".length(), shard.length());
            int taskNum = Integer.parseInt(taskId);
            int outputShardNum = taskNum / this.shards.size();
            LOG.debug("Merging into outputShardNum: " + outputShardNum + " from taskId: " + taskId);
            Path shardNumberFile = new Path(this.workDir.getParent().getParent(), "_solrShardNumber");
            FSDataOutputStream out = shardNumberFile.getFileSystem(context.getConfiguration()).create(shardNumberFile);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);
            writer.write(String.valueOf(outputShardNum));
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
    }
}

