/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import org.carrot2.util.CloseableUtils;

public final class StreamUtils {
    public static final Writer NULL_WRITER = new NullWriter();

    private StreamUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFullyAndClose(InputStream input) throws IOException {
        try {
            byte[] byArray = StreamUtils.readFully(input);
            return byArray;
        }
        finally {
            CloseableUtils.close((Closeable)input);
        }
    }

    public static byte[] readFully(InputStream input) throws IOException {
        int z;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
        byte[] buffer = new byte[8192];
        while ((z = input.read(buffer)) > 0) {
            baos.write(buffer, 0, z);
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] readFullyAndClose(Reader input) throws IOException {
        try {
            char[] cArray = StreamUtils.readFully(input);
            return cArray;
        }
        finally {
            CloseableUtils.close((Closeable)input);
        }
    }

    public static char[] readFully(Reader input) throws IOException {
        int z;
        CharArrayWriter baos = new CharArrayWriter(8192);
        char[] buffer = new char[8192];
        while ((z = input.read(buffer)) > 0) {
            baos.write(buffer, 0, z);
        }
        return baos.toCharArray();
    }

    public static InputStream prefetch(InputStream stream) throws IOException {
        if (stream instanceof ByteArrayInputStream) {
            return stream;
        }
        return new ByteArrayInputStream(StreamUtils.readFullyAndClose(stream));
    }

    public static void copy(InputStream in, OutputStream out, int bufSize) throws IOException {
        int tmp;
        byte[] buffer = new byte[bufSize];
        while ((tmp = in.read(buffer)) > 0) {
            out.write(buffer, 0, tmp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyAndClose(InputStream in, OutputStream out, int bufSize) throws IOException {
        try {
            StreamUtils.copy(in, out, bufSize);
        }
        catch (Throwable throwable) {
            CloseableUtils.close(in, out);
            throw throwable;
        }
        CloseableUtils.close(in, out);
    }

    static class NullWriter
    extends Writer {
        NullWriter() {
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
        }
    }
}

