/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.icu.segmentation;

import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.text.RuleBasedBreakIterator;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.io.InputStream;
import org.apache.lucene.analysis.icu.segmentation.ICUTokenizerConfig;
import org.apache.lucene.analysis.standard.StandardTokenizer;

public class DefaultICUTokenizerConfig
extends ICUTokenizerConfig {
    public static final String WORD_IDEO = StandardTokenizer.TOKEN_TYPES[10];
    public static final String WORD_HIRAGANA = StandardTokenizer.TOKEN_TYPES[11];
    public static final String WORD_KATAKANA = StandardTokenizer.TOKEN_TYPES[12];
    public static final String WORD_HANGUL = StandardTokenizer.TOKEN_TYPES[13];
    public static final String WORD_LETTER = StandardTokenizer.TOKEN_TYPES[0];
    public static final String WORD_NUMBER = StandardTokenizer.TOKEN_TYPES[6];
    private static final BreakIterator cjkBreakIterator = BreakIterator.getWordInstance((ULocale)ULocale.ROOT);
    private static final BreakIterator defaultBreakIterator = DefaultICUTokenizerConfig.readBreakIterator("Default.brk");
    private static final BreakIterator khmerBreakIterator = DefaultICUTokenizerConfig.readBreakIterator("Khmer.brk");
    private final boolean cjkAsWords;

    public DefaultICUTokenizerConfig(boolean cjkAsWords) {
        this.cjkAsWords = cjkAsWords;
    }

    @Override
    public boolean combineCJ() {
        return this.cjkAsWords;
    }

    @Override
    public BreakIterator getBreakIterator(int script) {
        switch (script) {
            case 23: {
                return (BreakIterator)khmerBreakIterator.clone();
            }
            case 105: {
                return (BreakIterator)cjkBreakIterator.clone();
            }
        }
        return (BreakIterator)defaultBreakIterator.clone();
    }

    @Override
    public String getType(int script, int ruleStatus) {
        switch (ruleStatus) {
            case 400: {
                return WORD_IDEO;
            }
            case 300: {
                return script == 20 ? WORD_HIRAGANA : WORD_KATAKANA;
            }
            case 200: {
                return script == 18 ? WORD_HANGUL : WORD_LETTER;
            }
            case 100: {
                return WORD_NUMBER;
            }
        }
        return "<OTHER>";
    }

    private static RuleBasedBreakIterator readBreakIterator(String filename) {
        InputStream is = DefaultICUTokenizerConfig.class.getResourceAsStream(filename);
        try {
            RuleBasedBreakIterator bi = RuleBasedBreakIterator.getInstanceFromCompiledRules((InputStream)is);
            is.close();
            return bi;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

