/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.examples.tagger;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.uima.TokenAnnotation;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.analysis_engine.annotator.AnnotatorConfigurationException;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.examples.tagger.IModelResource;
import org.apache.uima.examples.tagger.Tagger;
import org.apache.uima.examples.tagger.Viterbi;
import org.apache.uima.examples.tagger.trainAndTest.MappingInterface;
import org.apache.uima.examples.tagger.trainAndTest.ModelGeneration;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;

public class HMMTagger
extends JCasAnnotator_ImplBase
implements Tagger {
    private static final String model_file_param = "Model";
    private static final String n_param = "NGRAM_SIZE";
    public static String PARAM_INPUT_VIEW = "InputView";
    public static String PARAM_IMPORT_MODEL_FILE = "ModelFile";
    public static String PARAM_SENTENCE = "SentenceType";
    public static String PARAM_TOKEN_FP = "TokenFeaturePath";
    private static final String DEFAULT_INPUT_VIEW = "_InitialView";
    private static final String DEFAULT_SENTENCE_TYPE = "org.apache.uima.SentenceAnnotation";
    private static final String DEFAULT_TOKEN_FEATURE_PATH = "org.apache.uima.TokenAnnotation:posTag";
    private String inputView;
    private String modelFile;
    private String theSentenceTypeName;
    private String theTokenTypeName;
    private String thePOSAttribute;
    public int N;
    public ModelGeneration my_model;
    MappingInterface MAPPING;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        Integer idx;
        String fpPOS;
        super.initialize(aContext);
        this.inputView = (String)aContext.getConfigParameterValue(PARAM_INPUT_VIEW);
        if (this.inputView == null) {
            this.inputView = DEFAULT_INPUT_VIEW;
        }
        this.theSentenceTypeName = (String)aContext.getConfigParameterValue(PARAM_SENTENCE);
        if (this.theSentenceTypeName == null) {
            this.theSentenceTypeName = DEFAULT_SENTENCE_TYPE;
        }
        if ((fpPOS = (String)aContext.getConfigParameterValue(PARAM_TOKEN_FP)) == null) {
            fpPOS = DEFAULT_TOKEN_FEATURE_PATH;
        }
        if ((idx = Integer.valueOf(fpPOS.lastIndexOf(":"))) < 0) {
            throw new ResourceInitializationException("The feature path passed in parameter ('" + fpPOS + "') is not valid. " + "It should be like : 'type.name:attribute'", null);
        }
        this.theTokenTypeName = fpPOS.substring(0, idx);
        this.thePOSAttribute = fpPOS.substring(idx + 1);
        try {
            this.N = (Integer)aContext.getConfigParameterValue(n_param);
            this.modelFile = (String)aContext.getConfigParameterValue(PARAM_IMPORT_MODEL_FILE);
            this.my_model = this.modelFile != null ? HMMTagger.get_model(this.modelFile) : this.get_model();
            if (this.my_model == null) {
                throw new ResourceInitializationException((Throwable)new Exception("Could not load model file."));
            }
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModelGeneration get_model(String filename) {
        System.out.println("The used model is:" + filename);
        FileInputStream model = null;
        ModelGeneration oRead = null;
        try {
            model = new FileInputStream(filename);
            ObjectInputStream p = new ObjectInputStream(model);
            oRead = (ModelGeneration)p.readObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            try {
                ((InputStream)model).close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return oRead;
    }

    private ModelGeneration get_model() throws AnnotatorConfigurationException {
        IModelResource modelResource = null;
        try {
            modelResource = (IModelResource)this.getContext().getResourceObject(model_file_param);
        }
        catch (Exception e) {
            throw new AnnotatorConfigurationException((Throwable)e);
        }
        return modelResource.getModel();
    }

    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        JCas workingView = null;
        try {
            workingView = aJCas.getView(this.inputView);
        }
        catch (CASException e1) {
            throw new AnalysisEngineProcessException((Throwable)e1);
        }
        ArrayList<TokenAnnotation> tokenList = new ArrayList<TokenAnnotation>();
        ArrayList<String> wordList = new ArrayList<String>();
        AnnotationIndex sentenceIndex = workingView.getAnnotationIndex(HMMTagger.getType(workingView, this.theSentenceTypeName));
        AnnotationIndex tokenIndex = workingView.getAnnotationIndex(HMMTagger.getType(workingView, this.theTokenTypeName));
        for (Annotation sentence : sentenceIndex) {
            tokenList.clear();
            wordList.clear();
            FSIterator tokenIterator = tokenIndex.subiterator((AnnotationFS)sentence);
            while (tokenIterator.hasNext()) {
                TokenAnnotation token = (TokenAnnotation)((Object)tokenIterator.next());
                tokenList.add(token);
                wordList.add(token.getCoveredText());
            }
            List wordTagList = Viterbi.process(this.N, wordList, this.my_model.suffix_tree, this.my_model.suffix_tree_capitalized, this.my_model.transition_probs, this.my_model.word_probs, this.my_model.lambdas2, this.my_model.lambdas3, this.my_model.theta);
            try {
                for (int i = 0; i < tokenList.size(); ++i) {
                    Annotation token = (Annotation)tokenList.get(i);
                    String posTag = (String)wordTagList.get(i);
                    Feature featPOS = HMMTagger.getType(workingView, this.theTokenTypeName).getFeatureByBaseName(this.thePOSAttribute);
                    token.setFeatureValueFromString(featPOS, posTag);
                }
            }
            catch (IndexOutOfBoundsException e) {
                System.err.println("POS tagger error - list of tags shorter than list of words");
            }
        }
    }

    public static Type getType(JCas aJCas, String annotationString) throws AnalysisEngineProcessException {
        Type annotationType = null;
        annotationType = aJCas.getTypeSystem().getType(annotationString);
        if (annotationType == null) {
            throw new AnalysisEngineProcessException("Error: Type " + annotationString + " is not defined in the Type System !", new Object[]{annotationType});
        }
        return annotationType;
    }
}

