/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.util.DataInputInputStream;
import org.apache.solr.common.util.FastInputStream;
import org.apache.solr.common.util.FastOutputStream;
import org.apache.solr.common.util.ObjectReleaseTracker;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.FSDataFastInputStream;
import org.apache.solr.update.TransactionLog;
import org.apache.solr.update.UpdateLog;
import org.apache.solr.util.FSHDFSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsTransactionLog
extends TransactionLog {
    public static Logger log = LoggerFactory.getLogger(HdfsTransactionLog.class);
    Path tlogFile;
    private FSDataOutputStream tlogOutStream;
    private FileSystem fs;
    private volatile boolean isClosed = false;

    HdfsTransactionLog(FileSystem fs, Path tlogFile, Collection<String> globalStrings, Integer tlogDfsReplication) {
        this(fs, tlogFile, globalStrings, false, tlogDfsReplication);
    }

    HdfsTransactionLog(FileSystem fs, Path tlogFile, Collection<String> globalStrings, boolean openExisting, Integer tlogDfsReplication) {
        boolean success = false;
        this.fs = fs;
        try {
            if (this.debug) {
                // empty if block
            }
            this.tlogFile = tlogFile;
            if (fs.exists(tlogFile) && openExisting) {
                FSHDFSUtils.recoverFileLease(fs, tlogFile, fs.getConf(), new FSHDFSUtils.CallerInfo(){

                    @Override
                    public boolean isCallerClosed() {
                        return HdfsTransactionLog.this.isClosed;
                    }
                });
                this.tlogOutStream = fs.append(tlogFile);
            } else {
                fs.delete(tlogFile, false);
                this.tlogOutStream = fs.create(tlogFile, (short)tlogDfsReplication.intValue());
                this.tlogOutStream.hsync();
            }
            this.fos = new FastOutputStream((OutputStream)this.tlogOutStream, new byte[65536], 0);
            long start = this.tlogOutStream.getPos();
            if (openExisting) {
                if (start > 0L) {
                    this.readHeader(null);
                    this.fos.setWritten(start);
                } else {
                    this.addGlobalStrings(globalStrings);
                }
            } else {
                if (start > 0L) {
                    log.error("New transaction log already exists:" + tlogFile + " size=" + this.tlogOutStream.size());
                }
                this.addGlobalStrings(globalStrings);
            }
            success = true;
            assert (ObjectReleaseTracker.track((Object)this));
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        finally {
            if (!success && this.tlogOutStream != null) {
                try {
                    this.tlogOutStream.close();
                }
                catch (Exception e) {
                    log.error("Error closing tlog file (after error opening)", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean endsWithCommit() throws IOException {
        long size;
        HdfsTransactionLog hdfsTransactionLog = this;
        synchronized (hdfsTransactionLog) {
            this.fos.flush();
            this.tlogOutStream.hflush();
            size = this.fos.size();
        }
        byte[] buf = new byte["SOLR_TLOG_END".length()];
        long pos = size - (long)"SOLR_TLOG_END".length() - 4L;
        if (pos < 0L) {
            return false;
        }
        try (FSDataFastInputStream dis = new FSDataFastInputStream(this.fs.open(this.tlogFile), pos);){
            dis.read(buf);
            for (int i = 0; i < buf.length; ++i) {
                if (buf[i] == "SOLR_TLOG_END".charAt(i)) continue;
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(long pos) throws IOException {
        HdfsTransactionLog hdfsTransactionLog = this;
        synchronized (hdfsTransactionLog) {
            assert (this.snapshot_size == pos);
            this.fos.flush();
            this.tlogOutStream.hflush();
            this.fos.setWritten(pos);
            assert (this.fos.size() == pos);
            this.numRecords = this.snapshot_numRecords;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readHeader(FastInputStream fis) throws IOException {
        boolean closeFis = false;
        if (fis == null) {
            closeFis = true;
        }
        fis = fis != null ? fis : new FSDataFastInputStream(this.fs.open(this.tlogFile), 0L);
        Map header = null;
        try {
            TransactionLog.LogCodec codec = new TransactionLog.LogCodec(this, this.resolver);
            header = (Map)codec.unmarshal((InputStream)fis);
            fis.readInt();
        }
        finally {
            if (fis != null && closeFis) {
                fis.close();
            }
        }
        HdfsTransactionLog hdfsTransactionLog = this;
        synchronized (hdfsTransactionLog) {
            this.globalStringList = (List)header.get("strings");
            this.globalStringMap = new HashMap(this.globalStringList.size());
            for (int i = 0; i < this.globalStringList.size(); ++i) {
                this.globalStringMap.put(this.globalStringList.get(i), i + 1);
            }
        }
    }

    @Override
    public long writeCommit(CommitUpdateCommand cmd, int flags) {
        TransactionLog.LogCodec codec = new TransactionLog.LogCodec(this, this.resolver);
        HdfsTransactionLog hdfsTransactionLog = this;
        synchronized (hdfsTransactionLog) {
            try {
                long pos = this.fos.size();
                if (pos == 0L) {
                    this.writeLogHeader(codec);
                    pos = this.fos.size();
                }
                codec.init(this.fos);
                codec.writeTag((byte)-128, 3);
                codec.writeInt(4 | flags);
                codec.writeLong(cmd.getVersion());
                codec.writeStr("SOLR_TLOG_END");
                this.endRecord(pos);
                this.fos.flush();
                this.tlogOutStream.hflush();
                return pos;
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object lookup(long pos) {
        Object object;
        if (pos < 0L) {
            return null;
        }
        HdfsTransactionLog hdfsTransactionLog = this;
        synchronized (hdfsTransactionLog) {
            this.fos.flushBuffer();
            this.tlogOutStream.hflush();
        }
        FSDataFastInputStream dis = new FSDataFastInputStream(this.fs.open(this.tlogFile), pos);
        try {
            dis.seek(pos);
            TransactionLog.LogCodec codec = new TransactionLog.LogCodec(this, this.resolver);
            object = codec.readVal((DataInputInputStream)new FastInputStream((InputStream)((Object)dis)));
        }
        catch (Throwable throwable) {
            try {
                dis.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "pos=" + pos, (Throwable)e);
            }
        }
        dis.close();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish(UpdateLog.SyncLevel syncLevel) {
        if (syncLevel == UpdateLog.SyncLevel.NONE) {
            return;
        }
        try {
            HdfsTransactionLog hdfsTransactionLog = this;
            synchronized (hdfsTransactionLog) {
                this.fos.flushBuffer();
            }
            if (syncLevel == UpdateLog.SyncLevel.FSYNC) {
                this.tlogOutStream.hsync();
            } else {
                this.tlogOutStream.hflush();
            }
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void close() {
        try {
            if (this.debug) {
                log.debug("Closing tlog" + this);
            }
            HdfsTransactionLog hdfsTransactionLog = this;
            synchronized (hdfsTransactionLog) {
                this.fos.flushBuffer();
            }
            this.tlogOutStream.hflush();
            this.tlogOutStream.close();
        }
        catch (IOException e) {
            log.error("Exception closing tlog.", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        finally {
            this.isClosed = true;
            assert (ObjectReleaseTracker.release((Object)this));
            if (this.deleteOnClose) {
                try {
                    this.fs.delete(this.tlogFile, true);
                }
                catch (IOException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
                }
            }
        }
    }

    @Override
    public String toString() {
        return "hdfs tlog{file=" + this.tlogFile.toString() + " refcount=" + this.refcount.get() + "}";
    }

    @Override
    public TransactionLog.LogReader getReader(long startingPos) {
        return new HDFSLogReader(startingPos);
    }

    @Override
    public TransactionLog.ReverseReader getReverseReader() throws IOException {
        return new HDFSReverseReader();
    }

    public class HDFSReverseReader
    extends TransactionLog.ReverseReader {
        FSDataFastInputStream fis;
        private TransactionLog.LogCodec codec;
        int nextLength;
        long prevPos;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public HDFSReverseReader() throws IOException {
            long sz;
            super(HdfsTransactionLog.this);
            this.codec = new TransactionLog.LogCodec(HdfsTransactionLog.this.resolver){

                public SolrInputDocument readSolrInputDocument(DataInputInputStream dis) {
                    return null;
                }
            };
            HdfsTransactionLog.this.incref();
            HdfsTransactionLog hdfsTransactionLog2 = HdfsTransactionLog.this;
            synchronized (hdfsTransactionLog2) {
                HdfsTransactionLog.this.fos.flushBuffer();
                HdfsTransactionLog.this.tlogOutStream.hflush();
                sz = HdfsTransactionLog.this.fos.size();
            }
            this.fis = new FSDataFastInputStream(HdfsTransactionLog.this.fs.open(HdfsTransactionLog.this.tlogFile), 0L);
            if (sz >= 4L) {
                this.prevPos = sz - 4L;
                this.fis.seek(this.prevPos);
                this.nextLength = this.fis.readInt();
            }
        }

        @Override
        public Object next() throws IOException {
            if (this.prevPos <= 0L) {
                return null;
            }
            long endOfThisRecord = this.prevPos;
            int thisLength = this.nextLength;
            long recordStart = this.prevPos - (long)thisLength;
            this.prevPos = recordStart - 4L;
            if (this.prevPos <= 0L) {
                return null;
            }
            long bufferPos = this.fis.getBufferPos();
            if (this.prevPos < bufferPos) {
                long seekPos = endOfThisRecord - (long)this.fis.getBufferSize();
                seekPos = Math.min(seekPos, this.prevPos);
                seekPos = Math.max(seekPos, 0L);
                this.fis.seek(seekPos);
                this.fis.peek();
            }
            this.fis.seek(this.prevPos);
            this.nextLength = this.fis.readInt();
            Object o = this.codec.readVal((DataInputInputStream)this.fis);
            return o;
        }

        @Override
        public long position() {
            return this.prevPos + 4L;
        }

        @Override
        public void close() {
            try {
                this.fis.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            HdfsTransactionLog.this.decref();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String toString() {
            HdfsTransactionLog hdfsTransactionLog = HdfsTransactionLog.this;
            synchronized (hdfsTransactionLog) {
                return "LogReader{file=" + HdfsTransactionLog.this.tlogFile + ", position=" + this.fis.position() + ", end=" + HdfsTransactionLog.this.fos.size() + "}";
            }
        }
    }

    public class HDFSLogReader
    extends TransactionLog.LogReader {
        FSDataFastInputStream fis;
        private TransactionLog.LogCodec codec;
        private long sz;

        public HDFSLogReader(long startingPos) {
            super(HdfsTransactionLog.this);
            this.codec = new TransactionLog.LogCodec(HdfsTransactionLog.this, HdfsTransactionLog.this.resolver);
            HdfsTransactionLog.this.incref();
            try {
                FSDataInputStream fdis = HdfsTransactionLog.this.fs.open(HdfsTransactionLog.this.tlogFile);
                this.sz = HdfsTransactionLog.this.fs.getFileStatus(HdfsTransactionLog.this.tlogFile).getLen();
                this.fis = new FSDataFastInputStream(fdis, startingPos);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object next() throws IOException, InterruptedException {
            long pos = this.fis.position();
            HdfsTransactionLog hdfsTransactionLog = HdfsTransactionLog.this;
            synchronized (hdfsTransactionLog) {
                if (HdfsTransactionLog.this.trace) {
                    log.trace("Reading log record.  pos=" + pos + " currentSize=" + HdfsTransactionLog.this.fos.size());
                }
                if (pos >= HdfsTransactionLog.this.fos.size()) {
                    return null;
                }
                HdfsTransactionLog.this.fos.flushBuffer();
            }
            if (this.fis.position() >= this.sz) {
                this.fis.close();
                HdfsTransactionLog.this.tlogOutStream.hflush();
                try {
                    FSDataInputStream fdis = HdfsTransactionLog.this.fs.open(HdfsTransactionLog.this.tlogFile);
                    this.fis = new FSDataFastInputStream(fdis, pos);
                    this.sz = HdfsTransactionLog.this.fs.getFileStatus(HdfsTransactionLog.this.tlogFile).getLen();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (pos == 0L) {
                HdfsTransactionLog.this.readHeader(this.fis);
                HdfsTransactionLog e = HdfsTransactionLog.this;
                synchronized (e) {
                    if (this.fis.position() >= HdfsTransactionLog.this.fos.size()) {
                        return null;
                    }
                    pos = this.fis.position();
                }
            }
            Object o = this.codec.readVal((DataInputInputStream)this.fis);
            int size = this.fis.readInt();
            assert ((long)size == this.fis.position() - pos - 4L);
            return o;
        }

        @Override
        public void close() {
            try {
                this.fis.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            HdfsTransactionLog.this.decref();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String toString() {
            HdfsTransactionLog hdfsTransactionLog = HdfsTransactionLog.this;
            synchronized (hdfsTransactionLog) {
                return "LogReader{file=" + HdfsTransactionLog.this.tlogFile + ", position=" + this.fis.position() + ", end=" + HdfsTransactionLog.this.fos.size() + "}";
            }
        }

        @Override
        public long currentPos() {
            return this.fis.position();
        }

        @Override
        public long currentSize() {
            return this.sz;
        }
    }
}

