/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.util;

import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.Container;
import com.googlecode.mp4parser.AbstractContainerBox;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Path {
    static Pattern component = Pattern.compile("(....|\\.\\.)(\\[(.*)\\])?");

    private Path() {
    }

    public static String createPath(Box box) {
        return Path.createPath(box, "");
    }

    private static String createPath(Box box, String path) {
        Container parent = box.getParent();
        int index = 0;
        List<Box> siblings = parent.getBoxes();
        for (Box sibling : siblings) {
            if (!sibling.getType().equals(box.getType())) continue;
            if (sibling == box) break;
            ++index;
        }
        path = String.valueOf(String.format("/%s[%d]", box.getType(), index)) + path;
        if (parent instanceof Box) {
            return Path.createPath((Box)((Object)parent), path);
        }
        return path;
    }

    public static Box getPath(Box box, String path) {
        List<Box> all = Path.getPaths(box, path, true);
        return all.isEmpty() ? null : all.get(0);
    }

    public static Box getPath(Container container, String path) {
        List<Box> all = Path.getPaths(container, path, true);
        return all.isEmpty() ? null : all.get(0);
    }

    public static Box getPath(AbstractContainerBox containerBox, String path) {
        List<Box> all = Path.getPaths(containerBox, path, true);
        return all.isEmpty() ? null : all.get(0);
    }

    public static List<Box> getPaths(AbstractContainerBox containerBox, String path) {
        return Path.getPaths(containerBox, path, false);
    }

    public static List<Box> getPaths(Box box, String path) {
        return Path.getPaths(box, path, false);
    }

    public static List<Box> getPaths(Container container, String path) {
        return Path.getPaths(container, path, false);
    }

    private static List<Box> getPaths(AbstractContainerBox container, String path, boolean singleResult) {
        return Path.getPaths((Object)container, path, singleResult);
    }

    private static List<Box> getPaths(Container container, String path, boolean singleResult) {
        return Path.getPaths((Object)container, path, singleResult);
    }

    private static List<Box> getPaths(Box box, String path, boolean singleResult) {
        return Path.getPaths((Object)box, path, singleResult);
    }

    private static List<Box> getPaths(Object thing, String path, boolean singleResult) {
        String now;
        String later;
        if (path.startsWith("/")) {
            path = path.substring(1);
            while (thing instanceof Box) {
                thing = ((Box)thing).getParent();
            }
        }
        if (path.length() == 0) {
            if (thing instanceof Box) {
                return Collections.singletonList((Box)thing);
            }
            throw new RuntimeException("Result of path expression seems to be the root container. This is not allowed!");
        }
        if (path.contains("/")) {
            later = path.substring(path.indexOf(47) + 1);
            now = path.substring(0, path.indexOf(47));
        } else {
            now = path;
            later = "";
        }
        Matcher m = component.matcher(now);
        if (m.matches()) {
            String type = m.group(1);
            if ("..".equals(type)) {
                if (thing instanceof Box) {
                    return Path.getPaths(((Box)thing).getParent(), later, singleResult);
                }
                return Collections.emptyList();
            }
            if (thing instanceof Container) {
                int index = -1;
                if (m.group(2) != null) {
                    String indexString = m.group(3);
                    index = Integer.parseInt(indexString);
                }
                LinkedList<Box> children = new LinkedList<Box>();
                int currentIndex = 0;
                for (Box box1 : ((Container)thing).getBoxes()) {
                    if (box1.getType().matches(type)) {
                        if (index == -1 || index == currentIndex) {
                            children.addAll(Path.getPaths(box1, later, singleResult));
                        }
                        ++currentIndex;
                    }
                    if (!singleResult && index < 0 || children.isEmpty()) continue;
                    return children;
                }
                return children;
            }
            return Collections.emptyList();
        }
        throw new RuntimeException(String.valueOf(now) + " is invalid path.");
    }

    public static boolean isContained(Box box, String path) {
        assert (path.startsWith("/")) : "Absolute path required";
        return Path.getPaths(box, path).contains(box);
    }
}

