/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.twitter;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.typesafe.config.Config;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Random;
import java.util.zip.GZIPInputStream;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.CommandBuilder;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.stdio.AbstractParser;

public final class ReadJsonTestTweetsBuilder
implements CommandBuilder {
    public Collection<String> getNames() {
        return Collections.singletonList("readJsonTestTweets");
    }

    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new ReadJsonTestTweets(this, config, parent, child, context);
    }

    private static final class ReadJsonTestTweets
    extends AbstractParser {
        private final boolean isLengthDelimited;
        private String idPrefix;
        private final ObjectReader reader = new ObjectMapper().reader(JsonNode.class);
        private SimpleDateFormat formatterFrom = new SimpleDateFormat("EEE MMM dd HH:mm:ss Z yyyy", Locale.US);
        private SimpleDateFormat formatterTo = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);

        public ReadJsonTestTweets(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            this.isLengthDelimited = this.getConfigs().getBoolean(config, "isLengthDelimited", true);
            this.idPrefix = this.getConfigs().getString(config, "idPrefix", null);
            if ("random".equals(this.idPrefix)) {
                this.idPrefix = String.valueOf(new Random().nextInt());
            } else if (this.idPrefix == null) {
                this.idPrefix = "";
            }
            this.validateArguments();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean doProcess(Record record, InputStream in) throws IOException {
            String name = (String)record.getFirstValue("_attachment_name");
            if (name != null && name.endsWith(".gz")) {
                in = new GZIPInputStream(in, 65536);
            }
            long numRecords = 0L;
            BufferedReader bufferedReader = null;
            MappingIterator iter = null;
            if (this.isLengthDelimited) {
                bufferedReader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            } else {
                iter = this.reader.readValues(in);
            }
            try {
                while (true) {
                    JsonNode rootNode;
                    block16: {
                        if (this.isLengthDelimited) {
                            String json = this.nextLine(bufferedReader);
                            if (json == null) {
                                break;
                            }
                            try {
                                rootNode = (JsonNode)this.reader.readValue(json);
                                break block16;
                            }
                            catch (JsonParseException e) {
                                this.LOG.info("json parse exception after " + numRecords + " records");
                                this.LOG.debug("json parse exception after " + numRecords + " records", (Throwable)e);
                                break;
                            }
                        }
                        if (!iter.hasNext()) {
                            break;
                        }
                        rootNode = (JsonNode)iter.next();
                    }
                    Record doc = new Record();
                    JsonNode user = rootNode.get("user");
                    JsonNode idNode = rootNode.get("id_str");
                    if (idNode == null || idNode.textValue() == null) continue;
                    doc.put("id", (Object)(this.idPrefix + idNode.textValue()));
                    this.tryAddDate(doc, "created_at", rootNode.get("created_at"));
                    this.tryAddString(doc, "source", rootNode.get("source"));
                    this.tryAddString(doc, "text", rootNode.get("text"));
                    this.tryAddInt(doc, "retweet_count", rootNode.get("retweet_count"));
                    this.tryAddBool(doc, "retweeted", rootNode.get("retweeted"));
                    this.tryAddLong(doc, "in_reply_to_user_id", rootNode.get("in_reply_to_user_id"));
                    this.tryAddLong(doc, "in_reply_to_status_id", rootNode.get("in_reply_to_status_id"));
                    this.tryAddString(doc, "media_url_https", rootNode.get("media_url_https"));
                    this.tryAddString(doc, "expanded_url", rootNode.get("expanded_url"));
                    this.tryAddInt(doc, "user_friends_count", user.get("friends_count"));
                    this.tryAddString(doc, "user_location", user.get("location"));
                    this.tryAddString(doc, "user_description", user.get("description"));
                    this.tryAddInt(doc, "user_statuses_count", user.get("statuses_count"));
                    this.tryAddInt(doc, "user_followers_count", user.get("followers_count"));
                    this.tryAddString(doc, "user_screen_name", user.get("screen_name"));
                    this.tryAddString(doc, "user_name", user.get("name"));
                    this.incrementNumRecords();
                    this.LOG.debug("tweetdoc: {}", (Object)doc);
                    if (!this.getChild().process(doc)) {
                        boolean bl = false;
                        return bl;
                    }
                    ++numRecords;
                }
            }
            finally {
                if (iter != null) {
                    iter.close();
                }
                this.LOG.debug("processed {} records", (Object)numRecords);
            }
            return true;
        }

        private String nextLine(BufferedReader reader) throws IOException {
            String line;
            while ((line = reader.readLine()) != null && line.length() <= 0) {
            }
            if (line == null) {
                return null;
            }
            Integer.parseInt(line);
            while ((line = reader.readLine()) != null && line.length() <= 0) {
            }
            return line;
        }

        private void tryAddDate(Record doc, String solr_field, JsonNode node) {
            if (node == null) {
                return;
            }
            String val = node.asText();
            if (val == null) {
                return;
            }
            try {
                doc.put(solr_field, (Object)this.formatterTo.format(this.formatterFrom.parse(val.trim())));
            }
            catch (Exception e) {
                this.LOG.error("Could not parse date " + val);
            }
        }

        private void tryAddLong(Record doc, String solr_field, JsonNode node) {
            if (node == null) {
                return;
            }
            Long val = node.asLong();
            if (val == null) {
                return;
            }
            doc.put(solr_field, (Object)val);
        }

        private void tryAddInt(Record doc, String solr_field, JsonNode node) {
            if (node == null) {
                return;
            }
            Integer val = node.asInt();
            if (val == null) {
                return;
            }
            doc.put(solr_field, (Object)val);
        }

        private void tryAddBool(Record doc, String solr_field, JsonNode node) {
            if (node == null) {
                return;
            }
            Boolean val = node.asBoolean();
            if (val == null) {
                return;
            }
            doc.put(solr_field, (Object)val);
        }

        private void tryAddString(Record doc, String solr_field, JsonNode node) {
            if (node == null) {
                return;
            }
            String val = node.asText();
            if (val == null) {
                return;
            }
            doc.put(solr_field, (Object)val);
        }
    }
}

