/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.examples.tagger.trainAndTest;

import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.uima.examples.tagger.HMMTagger;
import org.apache.uima.examples.tagger.Viterbi;
import org.apache.uima.examples.tagger.trainAndTest.CorpusReader;
import org.apache.uima.examples.tagger.trainAndTest.MappingInterface;
import org.apache.uima.examples.tagger.trainAndTest.ModelGeneration;
import org.apache.uima.examples.tagger.trainAndTest.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaggerEvaluation {
    static void get_eval(ModelGeneration my_model, List<String> wordList, List<String> posList, List<String> TagList) {
        int wrong_tag = 0;
        int right_tags = 0;
        ArrayList<String> unknown_list = new ArrayList<String>();
        int unknown_count = 0;
        int unknown_all = 0;
        ArrayList<String> wrong_tags = new ArrayList<String>();
        HashMap<String, Integer> wrong_tag_counts = new HashMap<String, Integer>();
        HashMap<String, Map<String, Integer>> wrong_tag_map = new HashMap<String, Map<String, Integer>>();
        int words = wordList.size();
        for (int u = 0; u < posList.size(); ++u) {
            if (!posList.get(u).equalsIgnoreCase(TagList.get(u))) {
                Map<String, Integer> tags;
                wrong_tags.add(posList.get(u));
                Integer freq = (Integer)wrong_tag_counts.get(posList.get(u));
                wrong_tag_counts.put(posList.get(u), freq == null ? 1 : freq + 1);
                if (wrong_tag_map.containsKey(posList.get(u))) {
                    Integer freq2;
                    tags.put(TagList.get(u), (freq2 = (Integer)(tags = (Map)wrong_tag_map.get(posList.get(u))).get(TagList.get(u))) == null ? 1 : freq2 + 1);
                } else {
                    tags = new HashMap<String, Integer>();
                    tags.put(TagList.get(u), 1);
                    wrong_tag_map.put(posList.get(u), tags);
                }
                ++wrong_tag;
                if (!my_model.word_probs.containsKey(wordList.get(u))) {
                    unknown_list.add(wordList.get(u));
                    ++unknown_count;
                }
            } else {
                ++right_tags;
            }
            if (my_model.word_probs.containsKey(wordList.get(u))) continue;
            ++unknown_all;
        }
        System.out.println(wordList.size() + " tokens in the corpus");
        double percent_unknown_errors = (double)unknown_count / (double)wrong_tag;
        System.out.println("percent of unknown words among erronously tagged: " + unknown_count + " (" + percent_unknown_errors * 100.0 + "%" + ")");
        System.out.println("percent of correctly tagged unknown words from all unknown: " + ((double)unknown_all - (double)unknown_count) / (double)unknown_all * 100.0 + "%");
        System.out.println("total words: " + words);
        System.out.println("total unknown words: " + unknown_all + "  == " + (double)unknown_all / (double)words + "%");
        double percent_errors = (double)wrong_tag / (double)words;
        System.out.println("total errors" + wrong_tag + " which makes up " + percent_errors + " of tokens");
        double accuracy = (double)right_tags / (double)words;
        System.out.println("accuracy:  " + accuracy);
        ArrayList sortedValues = new ArrayList(wrong_tag_counts.values());
        Collections.sort(sortedValues);
        Object[] keys = wrong_tag_counts.keySet().toArray();
        Object[] keys2 = wrong_tag_map.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            System.out.print(keys[i] + "  ");
            System.out.println(wrong_tag_counts.get(keys[i]));
            System.out.print(keys2[i]);
            System.out.print(":");
            System.out.println(wrong_tag_map.get(keys2[i]));
        }
    }

    public static void main(String[] args) {
        try {
            MappingInterface MAPPING;
            String paramFile = "tagger.properties";
            Properties defaultProps = new Properties();
            FileInputStream in = new FileInputStream(paramFile);
            defaultProps.load(in);
            in.close();
            String n = defaultProps.getProperty("N");
            String MODEL = defaultProps.getProperty("MODEL_FILE");
            ModelGeneration my_model = HMMTagger.get_model(MODEL);
            String t = defaultProps.getProperty("DO_MAPPING");
            my_model.N = Integer.parseInt(n);
            boolean DO_MAPPING = Boolean.valueOf(t);
            System.out.println("DO_MAPPING = " + DO_MAPPING);
            if (DO_MAPPING) {
                String m = defaultProps.getProperty("MAPPING");
                MAPPING = (MappingInterface)Class.forName(m).newInstance();
            } else {
                MAPPING = null;
            }
            String r = defaultProps.getProperty("CORPUS_READER");
            CorpusReader reader = (CorpusReader)Class.forName(r).newInstance();
            String file = defaultProps.getProperty("GOLD_STANDARD");
            List<Token> corpus = reader.read_corpus(file, MAPPING);
            ArrayList<String> wordList = new ArrayList<String>();
            ArrayList<String> posList = new ArrayList<String>();
            for (int x = 0; x < corpus.size(); ++x) {
                posList.add(corpus.get((int)x).pos);
                wordList.add(corpus.get((int)x).word);
            }
            List TagList = Viterbi.process(my_model.N, wordList, my_model.suffix_tree, my_model.suffix_tree_capitalized, my_model.transition_probs, my_model.word_probs, my_model.lambdas2, my_model.lambdas3, my_model.theta);
            TaggerEvaluation.get_eval(my_model, wordList, posList, TagList);
        }
        catch (Throwable th) {
            System.err.println(th);
        }
    }
}

