/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.Vector;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.resource.CasDefinition;
import org.apache.uima.resource.CasManager;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CasPool {
    private static final String LOG_RESOURCE_BUNDLE = "org.apache.uima.impl.log_messages";
    private static final Class<CasPool> CLASS_NAME = CasPool.class;
    private Vector<CAS> mAllInstances = new Vector();
    private Vector<CAS> mFreeInstances = new Vector();
    private int mNumInstances;

    public CasPool(int aNumInstances, Collection<? extends ProcessingResourceMetaData> aCollectionOfProcessingResourceMetaData, Properties aPerformanceTuningSettings, ResourceManager aResourceManager) throws ResourceInitializationException {
        this.mNumInstances = aNumInstances;
        this.fillPool(aCollectionOfProcessingResourceMetaData, aPerformanceTuningSettings, aResourceManager);
    }

    public CasPool(int aNumInstances, AnalysisEngine aAnalysisEngine) throws ResourceInitializationException {
        this.mNumInstances = aNumInstances;
        ArrayList<ProcessingResourceMetaData> mdList = new ArrayList<ProcessingResourceMetaData>();
        mdList.add((ProcessingResourceMetaData)aAnalysisEngine.getMetaData());
        this.fillPool(mdList, aAnalysisEngine.getPerformanceTuningSettings(), aAnalysisEngine.getResourceManager());
    }

    public CasPool(int aNumInstances, ProcessingResourceMetaData aMetaData) throws ResourceInitializationException {
        this.mNumInstances = aNumInstances;
        ArrayList<ProcessingResourceMetaData> mdList = new ArrayList<ProcessingResourceMetaData>();
        mdList.add(aMetaData);
        this.fillPool(mdList, null, null);
    }

    public CasPool(int aNumInstances, ProcessingResourceMetaData aMetaData, ResourceManager aResourceManager) throws ResourceInitializationException {
        this.mNumInstances = aNumInstances;
        ArrayList<ProcessingResourceMetaData> mdList = new ArrayList<ProcessingResourceMetaData>();
        mdList.add(aMetaData);
        this.fillPool(mdList, null, aResourceManager);
    }

    public CasPool(int aNumInstances, CasDefinition aCasDefinition, Properties aPerformanceTuningSettings) throws ResourceInitializationException {
        this.mNumInstances = aNumInstances;
        this.fillPool(aCasDefinition, aPerformanceTuningSettings);
    }

    public CasPool(int aNumInstances, CasManager aCasManager, Properties aPerformanceTuningSettings) throws ResourceInitializationException {
        this.mNumInstances = aNumInstances;
        this.fillPool(aCasManager, aPerformanceTuningSettings);
    }

    public synchronized CAS getCas() {
        if (!this.mFreeInstances.isEmpty()) {
            return this.mFreeInstances.remove(0);
        }
        return null;
    }

    public synchronized void releaseCas(CAS aCas) {
        CAS cas = aCas.getView("_InitialView");
        if (!this.mAllInstances.contains(cas) || this.mFreeInstances.contains(cas)) {
            UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "releaseCas", LOG_RESOURCE_BUNDLE, "UIMA_return_cas_to_pool__WARNING");
        } else {
            cas.reset();
            ((CASImpl)cas).restoreClassLoaderUnlockCas();
            this.mFreeInstances.add(cas);
        }
        this.notifyAll();
    }

    public synchronized CAS getCas(long aTimeout) {
        CAS cas;
        long startTime = System.currentTimeMillis();
        while ((cas = this.getCas()) == null) {
            try {
                this.wait(aTimeout);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (aTimeout <= 0L || System.currentTimeMillis() - startTime < aTimeout) continue;
            return null;
        }
        return cas;
    }

    public int getSize() {
        return this.mNumInstances;
    }

    public int getNumAvailable() {
        return this.getFreeInstances().size();
    }

    private void fillPool(Collection<? extends ProcessingResourceMetaData> mdList, Properties performanceTuningSettings, ResourceManager resourceManager) throws ResourceInitializationException {
        CasDefinition casDef = new CasDefinition(mdList, resourceManager);
        this.fillPool(casDef, performanceTuningSettings);
    }

    private void fillPool(CasDefinition casDef, Properties performanceTuningSettings) throws ResourceInitializationException {
        CAS c0 = CasCreationUtils.createCas(casDef, performanceTuningSettings);
        ((CASImpl)c0).setOwner(casDef.getCasManager());
        this.mAllInstances.add(c0);
        this.mFreeInstances.add(c0);
        for (int i = 1; i < this.mNumInstances; ++i) {
            CAS c = CasCreationUtils.createCas(casDef, performanceTuningSettings, c0.getTypeSystem());
            ((CASImpl)c).setOwner(casDef.getCasManager());
            this.mAllInstances.add(c);
            this.mFreeInstances.add(c);
        }
    }

    private void fillPool(CasManager casManager, Properties performanceTuningSettings) throws ResourceInitializationException {
        for (int i = 0; i < this.mNumInstances; ++i) {
            CAS c = casManager.createNewCas(performanceTuningSettings);
            ((CASImpl)c).setOwner(casManager);
            this.mAllInstances.add(c);
            this.mFreeInstances.add(c);
        }
    }

    protected Vector<CAS> getAllInstances() {
        return this.mAllInstances;
    }

    protected Vector<CAS> getFreeInstances() {
        return this.mFreeInstances;
    }
}

