/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.pear.tools;

import java.io.File;
import java.io.IOException;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.apache.uima.UIMAFramework;
import org.apache.uima.pear.tools.InstallationController;
import org.apache.uima.pear.tools.InstallationDescriptor;
import org.apache.uima.pear.tools.InstallationDescriptorHandler;
import org.apache.uima.pear.tools.PackageBrowser;
import org.apache.uima.pear.tools.PackageInstallerException;
import org.apache.uima.pear.util.MessageRouter;
import org.apache.uima.util.Level;
import org.xml.sax.SAXException;

public class PackageInstaller {
    private static final String PEAR_MESSAGE_RESOURCE_BUNDLE = "org.apache.uima.pear.pear_messages";

    public static PackageBrowser installPackage(File installDir, File pearPackage, boolean verify) throws PackageInstallerException {
        return PackageInstaller.installPackage(installDir, pearPackage, verify, true);
    }

    public static PackageBrowser installPackage(File installDir, File pearPackage, boolean verify, boolean cleanInstallDir) throws PackageInstallerException {
        return PackageInstaller.installPackage(installDir, pearPackage, verify, cleanInstallDir, false);
    }

    public static PackageBrowser installPackage(File installDir, File pearPackage, boolean verify, boolean cleanInstallDir, boolean installToTopLevelDir) throws PackageInstallerException {
        String componentId;
        block23: {
            ZipFile jarFile = null;
            try {
                if (!pearPackage.canRead()) {
                    throw new PackageInstallerException(PEAR_MESSAGE_RESOURCE_BUNDLE, "error_pear_package_path_invalid", new Object[]{pearPackage.getAbsolutePath()});
                }
                jarFile = new JarFile(pearPackage);
                InstallationDescriptorHandler insdHandler = new InstallationDescriptorHandler();
                insdHandler.parseInstallationDescriptor((JarFile)jarFile);
                InstallationDescriptor instObj = insdHandler.getInstallationDescriptor();
                if (instObj != null) {
                    componentId = instObj.getMainComponentId();
                    break block23;
                }
                throw new PackageInstallerException(PEAR_MESSAGE_RESOURCE_BUNDLE, "error_parsing_pear_package_desc", new Object[]{pearPackage.getAbsolutePath()});
            }
            catch (IOException ex) {
                throw new PackageInstallerException(PEAR_MESSAGE_RESOURCE_BUNDLE, "error_parsing_pear_package_desc", new Object[]{pearPackage.getAbsolutePath()}, ex);
            }
            catch (SAXException ex) {
                throw new PackageInstallerException(PEAR_MESSAGE_RESOURCE_BUNDLE, "error_parsing_pear_package_desc", new Object[]{pearPackage.getAbsolutePath()}, ex);
            }
            finally {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException ioe) {
                        throw new PackageInstallerException(PEAR_MESSAGE_RESOURCE_BUNDLE, "Can't close open PEAR file : " + jarFile.getName());
                    }
                }
            }
        }
        MessageRouter.StdChannelListener msgListener = new MessageRouter.StdChannelListener(){

            public void errMsgPosted(String errMsg) {
                UIMAFramework.getLogger(PackageInstaller.class).logrb(Level.SEVERE, "PackageInstaller", "installPackage", PackageInstaller.PEAR_MESSAGE_RESOURCE_BUNDLE, "package_installer_error", errMsg);
            }

            public void outMsgPosted(String outMsg) {
                UIMAFramework.getLogger(PackageInstaller.class).logrb(Level.INFO, "PackageInstaller", "installPackage", PackageInstaller.PEAR_MESSAGE_RESOURCE_BUNDLE, "package_installer_message", outMsg);
            }
        };
        InstallationController controller = new InstallationController(componentId, pearPackage, installDir, installToTopLevelDir, msgListener, cleanInstallDir);
        if (controller.installComponent() == null) {
            String errorMessage = controller.getInstallationMsg();
            controller.terminate();
            if (errorMessage != null) {
                throw new PackageInstallerException(PEAR_MESSAGE_RESOURCE_BUNDLE, "error_installing_main_component", new Object[]{componentId, errorMessage});
            }
            throw new PackageInstallerException(PEAR_MESSAGE_RESOURCE_BUNDLE, "error_installing_main_component_unknown", new Object[]{componentId});
        }
        try {
            controller.saveInstallationDescriptorFile();
        }
        catch (IOException ex) {
            controller.terminate();
            throw new PackageInstallerException(PEAR_MESSAGE_RESOURCE_BUNDLE, "error_installing_main_component", new Object[]{componentId, ex.getMessage()}, ex);
        }
        PackageBrowser pkgBrowser = null;
        try {
            File pearDir = installToTopLevelDir ? installDir : new File(installDir, componentId);
            pkgBrowser = new PackageBrowser(pearDir);
            if (pkgBrowser == null) {
                controller.terminate();
                throw new PackageInstallerException(PEAR_MESSAGE_RESOURCE_BUNDLE, "error_reading_installed_pear_settings", new Object[]{componentId});
            }
        }
        catch (IOException ex) {
            controller.terminate();
            throw new PackageInstallerException(PEAR_MESSAGE_RESOURCE_BUNDLE, "error_reading_installed_pear_settings", new Object[]{componentId}, ex);
        }
        if (verify) {
            if (!controller.verifyComponent()) {
                String errorMessage = controller.getVerificationMsg();
                controller.terminate();
                if (errorMessage != null) {
                    throw new PackageInstallerException(PEAR_MESSAGE_RESOURCE_BUNDLE, "error_verify_installation", new Object[]{componentId, errorMessage});
                }
                throw new PackageInstallerException(PEAR_MESSAGE_RESOURCE_BUNDLE, "error_verify_installation_unknown", new Object[]{componentId});
            }
            UIMAFramework.getLogger(PackageInstaller.class).logrb(Level.INFO, "PackageInstaller", "installPackage", PEAR_MESSAGE_RESOURCE_BUNDLE, "installation_verification_completed", componentId);
        }
        controller.terminate();
        return pkgBrowser;
    }
}

