/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas_data.impl;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.uima.cas_data.FeatureStructure;
import org.apache.uima.cas_data.FeatureValue;

public class FeatureStructureImpl
implements FeatureStructure {
    private static final long serialVersionUID = -1828536763993413045L;
    private Map<String, FeatureValue> mFeatureMap;
    private String mFSType = null;
    private String mId = null;
    private int[] mIndexed = new int[0];

    public FeatureStructureImpl() {
        this.mFeatureMap = new TreeMap<String, FeatureValue>();
    }

    public String getType() {
        return this.mFSType;
    }

    public void setType(String aType) {
        this.mFSType = aType;
    }

    public String[] getFeatureNames() {
        Set<String> aSet = this.mFeatureMap.keySet();
        String[] featureNames = new String[aSet.size()];
        aSet.toArray(featureNames);
        return featureNames;
    }

    public FeatureValue getFeatureValue(String aFeatureName) {
        return this.mFeatureMap.get(aFeatureName);
    }

    public void setFeatureValue(String aFeatureType, FeatureValue aValue) {
        this.mFeatureMap.put(aFeatureType, aValue);
    }

    public Object get() {
        return this;
    }

    public String toString() {
        int[] indexed;
        StringBuffer buf = new StringBuffer();
        buf.append('\n').append(this.getType()).append('\n');
        if (this.getId() != null) {
            buf.append("ID = ").append(this.getId()).append('\n');
        }
        if ((indexed = this.getIndexed()).length > 0) {
            buf.append("indexed = ").append(indexed[0]);
            for (int i = 1; i < indexed.length; ++i) {
                buf.append(' ').append(indexed[i]);
            }
            buf.append('\n');
        }
        String[] featNames = this.getFeatureNames();
        for (int i = 0; i < featNames.length; ++i) {
            buf.append(featNames[i]).append(" = ").append(this.getFeatureValue(featNames[i])).append('\n');
        }
        return buf.toString();
    }

    public String getId() {
        return this.mId;
    }

    @Deprecated
    public boolean isIndexed() {
        return this.mIndexed.length > 0;
    }

    public void setId(String string) {
        this.mId = string;
    }

    @Deprecated
    public void setIndexed(boolean b) {
        this.mIndexed = new int[]{1};
    }

    public int[] getIndexed() {
        return this.mIndexed;
    }

    public void setIndexed(int[] aIndexed) {
        this.mIndexed = aIndexed == null ? new int[0] : aIndexed;
    }
}

