/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.spatial4j.geo3d;

import org.apache.lucene.spatial.spatial4j.geo3d.Bounds;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoBBox;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoBBoxFactory;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoPoint;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoShape;
import org.apache.lucene.spatial.spatial4j.geo3d.Membership;
import org.apache.lucene.spatial.spatial4j.geo3d.Plane;
import org.apache.lucene.spatial.spatial4j.geo3d.Vector;

public class GeoDegeneratePoint
extends GeoPoint
implements GeoBBox {
    public final double latitude;
    public final double longitude;
    public final GeoPoint[] edgePoints;

    public GeoDegeneratePoint(double lat, double lon) {
        super(lat, lon);
        this.latitude = lat;
        this.longitude = lon;
        this.edgePoints = new GeoPoint[]{this};
    }

    @Override
    public GeoBBox expand(double angle) {
        double newTopLat = this.latitude + angle;
        double newBottomLat = this.latitude - angle;
        double newLeftLon = this.longitude - angle;
        double newRightLon = this.longitude + angle;
        return GeoBBoxFactory.makeGeoBBox(newTopLat, newBottomLat, newLeftLon, newRightLon);
    }

    @Override
    public GeoPoint[] getEdgePoints() {
        return this.edgePoints;
    }

    @Override
    public boolean intersects(Plane plane, GeoPoint[] notablePoints, Membership ... bounds) {
        if (!plane.evaluateIsZero(this)) {
            return false;
        }
        for (Membership m : bounds) {
            if (m.isWithin(this)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Bounds getBounds(Bounds bounds) {
        if (bounds == null) {
            bounds = new Bounds();
        }
        bounds.addPoint(this.latitude, this.longitude);
        return bounds;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof GeoDegeneratePoint)) {
            return false;
        }
        GeoDegeneratePoint other = (GeoDegeneratePoint)o;
        return other.latitude == this.latitude && other.longitude == this.longitude;
    }

    @Override
    public int hashCode() {
        long temp = Double.doubleToLongBits(this.latitude);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.longitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public String toString() {
        return "GeoDegeneratePoint: {lat=" + this.latitude + "(" + this.latitude * 180.0 / Math.PI + "), lon=" + this.longitude + "(" + this.longitude * 180.0 / Math.PI + ")}";
    }

    @Override
    public boolean isWithin(Vector point) {
        return this.isWithin(point.x, point.y, point.z);
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        return x == this.x && y == this.y && z == this.z;
    }

    @Override
    public double getRadius() {
        return 0.0;
    }

    @Override
    public GeoPoint getCenter() {
        return this;
    }

    @Override
    public int getRelationship(GeoShape shape) {
        if (shape.isWithin(this)) {
            return 0;
        }
        return 3;
    }
}

