/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.aggregate;

import java.util.ArrayList;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.lib.aggregate.UserDefinedValueAggregatorDescriptor;
import org.apache.hadoop.mapreduce.lib.aggregate.ValueAggregatorBaseDescriptor;
import org.apache.hadoop.mapreduce.lib.aggregate.ValueAggregatorDescriptor;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class ValueAggregatorJobBase<K1 extends WritableComparable<?>, V1 extends Writable> {
    public static final String DESCRIPTOR = "mapreduce.aggregate.descriptor";
    public static final String DESCRIPTOR_NUM = "mapreduce.aggregate.descriptor.num";
    public static final String USER_JAR = "mapreduce.aggregate.user.jar.file";
    protected static ArrayList<ValueAggregatorDescriptor> aggregatorDescriptorList = null;

    public static void setup(Configuration job) {
        ValueAggregatorJobBase.initializeMySpec(job);
        ValueAggregatorJobBase.logSpec();
    }

    protected static ValueAggregatorDescriptor getValueAggregatorDescriptor(String spec, Configuration conf) {
        if (spec == null) {
            return null;
        }
        String[] segments = spec.split(",", -1);
        String type = segments[0];
        if (type.compareToIgnoreCase("UserDefined") == 0) {
            String className = segments[1];
            return new UserDefinedValueAggregatorDescriptor(className, conf);
        }
        return null;
    }

    protected static ArrayList<ValueAggregatorDescriptor> getAggregatorDescriptors(Configuration conf) {
        int num = conf.getInt(DESCRIPTOR_NUM, 0);
        ArrayList<ValueAggregatorDescriptor> retv = new ArrayList<ValueAggregatorDescriptor>(num);
        for (int i = 0; i < num; ++i) {
            String spec = conf.get("mapreduce.aggregate.descriptor." + i);
            ValueAggregatorDescriptor ad = ValueAggregatorJobBase.getValueAggregatorDescriptor(spec, conf);
            if (ad == null) continue;
            retv.add(ad);
        }
        return retv;
    }

    private static void initializeMySpec(Configuration conf) {
        aggregatorDescriptorList = ValueAggregatorJobBase.getAggregatorDescriptors(conf);
        if (aggregatorDescriptorList.size() == 0) {
            aggregatorDescriptorList.add(new UserDefinedValueAggregatorDescriptor(ValueAggregatorBaseDescriptor.class.getCanonicalName(), conf));
        }
    }

    protected static void logSpec() {
    }
}

