/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.hadoop;

import java.io.IOException;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.ArgumentType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;

public class PathArgumentType
implements ArgumentType<Path> {
    private final Configuration conf;
    private FileSystem fs;
    private boolean acceptSystemIn = false;
    private boolean verifyExists = false;
    private boolean verifyNotExists = false;
    private boolean verifyIsFile = false;
    private boolean verifyIsDirectory = false;
    private boolean verifyCanRead = false;
    private boolean verifyCanWrite = false;
    private boolean verifyCanWriteParent = false;
    private boolean verifyCanExecute = false;
    private boolean verifyIsAbsolute = false;
    private boolean verifyHasScheme = false;
    private String verifyScheme = null;

    public PathArgumentType(Configuration conf) {
        this.conf = conf;
    }

    public PathArgumentType acceptSystemIn() {
        this.acceptSystemIn = true;
        return this;
    }

    public PathArgumentType verifyExists() {
        this.verifyExists = true;
        return this;
    }

    public PathArgumentType verifyNotExists() {
        this.verifyNotExists = true;
        return this;
    }

    public PathArgumentType verifyIsFile() {
        this.verifyIsFile = true;
        return this;
    }

    public PathArgumentType verifyIsDirectory() {
        this.verifyIsDirectory = true;
        return this;
    }

    public PathArgumentType verifyCanRead() {
        this.verifyCanRead = true;
        return this;
    }

    public PathArgumentType verifyCanWrite() {
        this.verifyCanWrite = true;
        return this;
    }

    public PathArgumentType verifyCanWriteParent() {
        this.verifyCanWriteParent = true;
        return this;
    }

    public PathArgumentType verifyCanExecute() {
        this.verifyCanExecute = true;
        return this;
    }

    public PathArgumentType verifyIsAbsolute() {
        this.verifyIsAbsolute = true;
        return this;
    }

    public PathArgumentType verifyHasScheme() {
        this.verifyHasScheme = true;
        return this;
    }

    public PathArgumentType verifyScheme(String scheme) {
        this.verifyScheme = scheme;
        return this;
    }

    public Path convert(ArgumentParser parser, Argument arg, String value) throws ArgumentParserException {
        Path file = new Path(value);
        try {
            this.fs = file.getFileSystem(this.conf);
            if (this.verifyHasScheme && !this.isSystemIn(file)) {
                this.verifyHasScheme(parser, file);
            }
            if (this.verifyScheme != null && !this.isSystemIn(file)) {
                this.verifyScheme(parser, file);
            }
            if (this.verifyIsAbsolute && !this.isSystemIn(file)) {
                this.verifyIsAbsolute(parser, file);
            }
            if (this.verifyExists && !this.isSystemIn(file)) {
                this.verifyExists(parser, file);
            }
            if (this.verifyNotExists && !this.isSystemIn(file)) {
                this.verifyNotExists(parser, file);
            }
            if (this.verifyIsFile && !this.isSystemIn(file)) {
                this.verifyIsFile(parser, file);
            }
            if (this.verifyIsDirectory && !this.isSystemIn(file)) {
                this.verifyIsDirectory(parser, file);
            }
            if (this.verifyCanRead && !this.isSystemIn(file)) {
                this.verifyCanRead(parser, file);
            }
            if (this.verifyCanWrite && !this.isSystemIn(file)) {
                this.verifyCanWrite(parser, file);
            }
            if (this.verifyCanWriteParent && !this.isSystemIn(file)) {
                this.verifyCanWriteParent(parser, file);
            }
            if (this.verifyCanExecute && !this.isSystemIn(file)) {
                this.verifyCanExecute(parser, file);
            }
        }
        catch (IOException e) {
            throw new ArgumentParserException((Throwable)e, parser);
        }
        return file;
    }

    private void verifyExists(ArgumentParser parser, Path file) throws ArgumentParserException, IOException {
        if (!this.fs.exists(file)) {
            throw new ArgumentParserException("File not found: " + file, parser);
        }
    }

    private void verifyNotExists(ArgumentParser parser, Path file) throws ArgumentParserException, IOException {
        if (this.fs.exists(file)) {
            throw new ArgumentParserException("File found: " + file, parser);
        }
    }

    private void verifyIsFile(ArgumentParser parser, Path file) throws ArgumentParserException, IOException {
        if (!this.fs.isFile(file)) {
            throw new ArgumentParserException("Not a file: " + file, parser);
        }
    }

    private void verifyIsDirectory(ArgumentParser parser, Path file) throws ArgumentParserException, IOException {
        if (!this.fs.isDirectory(file)) {
            throw new ArgumentParserException("Not a directory: " + file, parser);
        }
    }

    private void verifyCanRead(ArgumentParser parser, Path file) throws ArgumentParserException, IOException {
        this.verifyExists(parser, file);
        if (!this.fs.getFileStatus(file).getPermission().getUserAction().implies(FsAction.READ)) {
            throw new ArgumentParserException("Insufficient permissions to read file: " + file, parser);
        }
    }

    private void verifyCanWrite(ArgumentParser parser, Path file) throws ArgumentParserException, IOException {
        this.verifyExists(parser, file);
        if (!this.fs.getFileStatus(file).getPermission().getUserAction().implies(FsAction.WRITE)) {
            throw new ArgumentParserException("Insufficient permissions to write file: " + file, parser);
        }
    }

    private void verifyCanWriteParent(ArgumentParser parser, Path file) throws ArgumentParserException, IOException {
        Path parent = file.getParent();
        if (parent == null || !this.fs.exists(parent) || !this.fs.getFileStatus(parent).getPermission().getUserAction().implies(FsAction.WRITE)) {
            throw new ArgumentParserException("Cannot write parent of file: " + file, parser);
        }
    }

    private void verifyCanExecute(ArgumentParser parser, Path file) throws ArgumentParserException, IOException {
        this.verifyExists(parser, file);
        if (!this.fs.getFileStatus(file).getPermission().getUserAction().implies(FsAction.EXECUTE)) {
            throw new ArgumentParserException("Insufficient permissions to execute file: " + file, parser);
        }
    }

    private void verifyIsAbsolute(ArgumentParser parser, Path file) throws ArgumentParserException {
        if (!file.isAbsolute()) {
            throw new ArgumentParserException("Not an absolute file: " + file, parser);
        }
    }

    private void verifyHasScheme(ArgumentParser parser, Path file) throws ArgumentParserException {
        if (file.toUri().getScheme() == null) {
            throw new ArgumentParserException("URI scheme is missing in path: " + file, parser);
        }
    }

    private void verifyScheme(ArgumentParser parser, Path file) throws ArgumentParserException {
        if (!this.verifyScheme.equals(file.toUri().getScheme())) {
            throw new ArgumentParserException("Scheme of path: " + file + " must be: " + this.verifyScheme, parser);
        }
    }

    private boolean isSystemIn(Path file) {
        return this.acceptSystemIn && file.toString().equals("-");
    }
}

