/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.matrix.linalg;

import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.matrix.DoubleMatrix1D;
import org.apache.mahout.math.matrix.DoubleMatrix2D;
import org.apache.mahout.math.matrix.impl.AbstractMatrix2D;
import org.apache.mahout.math.matrix.impl.DenseDoubleMatrix2D;

@Deprecated
public final class Property {
    public static final Property DEFAULT = new Property(1.0E-9);
    public static final Property ZERO = new Property(0.0);
    private final double tolerance;

    public Property(double newTolerance) {
        this.tolerance = Math.abs(newTolerance);
    }

    public static void checkRectangular(AbstractMatrix2D a) {
        if (a.rows() < a.columns()) {
            throw new IllegalArgumentException("Matrix must be rectangular");
        }
    }

    public static void checkSquare(AbstractMatrix2D a) {
        if (a.rows() != a.columns()) {
            throw new IllegalArgumentException("Matrix must be square");
        }
    }

    public static void checkSquare(Matrix matrix) {
        if (matrix.numRows() != matrix.numCols()) {
            throw new IllegalArgumentException("Matrix must be square");
        }
    }

    public static double density(DoubleMatrix2D a) {
        return (double)a.cardinality() / (double)a.size();
    }

    public boolean equals(DoubleMatrix1D a, double value) {
        if (a == null) {
            return false;
        }
        double epsilon = this.tolerance();
        int i = a.size();
        while (--i >= 0) {
            double x = a.getQuick(i);
            double diff = Math.abs(value - x);
            if (Double.isNaN(diff) && (Double.isNaN(value) && Double.isNaN(x) || value == x)) {
                diff = 0.0;
            }
            if (!(diff > epsilon)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(DoubleMatrix1D a, DoubleMatrix1D b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        int size = a.size();
        if (size != b.size()) {
            return false;
        }
        double epsilon = this.tolerance();
        int i = size;
        while (--i >= 0) {
            double x = a.getQuick(i);
            double value = b.getQuick(i);
            double diff = Math.abs(value - x);
            if (Double.isNaN(diff) && (Double.isNaN(value) && Double.isNaN(x) || value == x)) {
                diff = 0.0;
            }
            if (!(diff > epsilon)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(DoubleMatrix2D a, double value) {
        if (a == null) {
            return false;
        }
        int rows = a.rows();
        int columns = a.columns();
        double epsilon = this.tolerance();
        int row = rows;
        while (--row >= 0) {
            int column = columns;
            while (--column >= 0) {
                double x = a.getQuick(row, column);
                double diff = Math.abs(value - x);
                if (Double.isNaN(diff) && (Double.isNaN(value) && Double.isNaN(x) || value == x)) {
                    diff = 0.0;
                }
                if (!(diff > epsilon)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(DoubleMatrix2D a, DoubleMatrix2D b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        int rows = a.rows();
        int columns = a.columns();
        if (columns != b.columns() || rows != b.rows()) {
            return false;
        }
        double epsilon = this.tolerance();
        int row = rows;
        while (--row >= 0) {
            int column = columns;
            while (--column >= 0) {
                double x = a.getQuick(row, column);
                double value = b.getQuick(row, column);
                double diff = Math.abs(value - x);
                if (Double.isNaN(diff) && (Double.isNaN(value) && Double.isNaN(x) || value == x)) {
                    diff = 0.0;
                }
                if (!(diff > epsilon)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isDiagonal(DoubleMatrix2D a) {
        double epsilon = this.tolerance();
        int rows = a.rows();
        int columns = a.columns();
        int row = rows;
        while (--row >= 0) {
            int column = columns;
            while (--column >= 0) {
                if (row == column || !(Math.abs(a.getQuick(row, column)) > epsilon)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isDiagonallyDominantByColumn(DoubleMatrix2D a) {
        int min;
        int i = min = Math.min(a.rows(), a.columns());
        while (--i >= 0) {
            double diag = Math.abs(a.getQuick(i, i));
            if (!((diag += diag) <= a.viewColumn(i).aggregate(Functions.PLUS, Functions.ABS))) continue;
            return false;
        }
        return true;
    }

    public static boolean isDiagonallyDominantByRow(DoubleMatrix2D a) {
        int min;
        int i = min = Math.min(a.rows(), a.columns());
        while (--i >= 0) {
            double diag = Math.abs(a.getQuick(i, i));
            if (!((diag += diag) <= a.viewRow(i).aggregate(Functions.PLUS, Functions.ABS))) continue;
            return false;
        }
        return true;
    }

    public boolean isIdentity(DoubleMatrix2D a) {
        double epsilon = this.tolerance();
        int rows = a.rows();
        int columns = a.columns();
        int row = rows;
        while (--row >= 0) {
            int column = columns;
            while (--column >= 0) {
                double v = a.getQuick(row, column);
                if (!(row == column ? Math.abs(1.0 - v) > epsilon : Math.abs(v) > epsilon)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isLowerBidiagonal(DoubleMatrix2D a) {
        double epsilon = this.tolerance();
        int rows = a.rows();
        int columns = a.columns();
        int row = rows;
        while (--row >= 0) {
            int column = columns;
            while (--column >= 0) {
                if (row == column || row == column + 1 || !(Math.abs(a.getQuick(row, column)) > epsilon)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isLowerTriangular(DoubleMatrix2D a) {
        int columns;
        double epsilon = this.tolerance();
        int rows = a.rows();
        int column = columns = a.columns();
        while (--column >= 0) {
            int row = Math.min(column, rows);
            while (--row >= 0) {
                if (!(Math.abs(a.getQuick(row, column)) > epsilon)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isNonNegative(DoubleMatrix2D a) {
        int rows = a.rows();
        int columns = a.columns();
        int row = rows;
        while (--row >= 0) {
            int column = columns;
            while (--column >= 0) {
                if (!(a.getQuick(row, column) < 0.0)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isOrthogonal(DoubleMatrix2D a) {
        Property.checkSquare(a);
        return this.equals(a.zMult(a, null, 1.0, 0.0, false, true), DenseDoubleMatrix2D.identity(a.rows()));
    }

    public static boolean isPositive(DoubleMatrix2D a) {
        int rows = a.rows();
        int columns = a.columns();
        int row = rows;
        while (--row >= 0) {
            int column = columns;
            while (--column >= 0) {
                if (!(a.getQuick(row, column) <= 0.0)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isSkewSymmetric(DoubleMatrix2D a) {
        int rows;
        Property.checkSquare(a);
        double epsilon = this.tolerance();
        int row = rows = a.rows();
        while (--row >= 0) {
            int column = rows;
            while (--column >= 0) {
                if (!(Math.abs(a.getQuick(row, column) + a.getQuick(column, row)) > epsilon)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isSquare(AbstractMatrix2D a) {
        return a.rows() == a.columns();
    }

    public boolean isStrictlyLowerTriangular(DoubleMatrix2D a) {
        int columns;
        double epsilon = this.tolerance();
        int rows = a.rows();
        int column = columns = a.columns();
        while (--column >= 0) {
            int row = Math.min(rows, column + 1);
            while (--row >= 0) {
                if (!(Math.abs(a.getQuick(row, column)) > epsilon)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isStrictlyTriangular(DoubleMatrix2D a) {
        if (this.isTriangular(a)) {
            double epsilon = this.tolerance();
            int i = Math.min(a.rows(), a.columns());
            while (--i >= 0) {
                if (!(Math.abs(a.getQuick(i, i)) > epsilon)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isStrictlyUpperTriangular(DoubleMatrix2D a) {
        int columns;
        double epsilon = this.tolerance();
        int rows = a.rows();
        int column = columns = a.columns();
        while (--column >= 0) {
            int row = rows;
            while (--row >= column) {
                if (!(Math.abs(a.getQuick(row, column)) > epsilon)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isSymmetric(DoubleMatrix2D a) {
        Property.checkSquare(a);
        return this.equals(a, a.viewDice());
    }

    public boolean isTriangular(DoubleMatrix2D a) {
        return this.isLowerTriangular(a) || this.isUpperTriangular(a);
    }

    public boolean isTridiagonal(DoubleMatrix2D a) {
        double epsilon = this.tolerance();
        int rows = a.rows();
        int columns = a.columns();
        int row = rows;
        while (--row >= 0) {
            int column = columns;
            while (--column >= 0) {
                if (Math.abs(row - column) <= 1 || !(Math.abs(a.getQuick(row, column)) > epsilon)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isUnitTriangular(DoubleMatrix2D a) {
        if (this.isTriangular(a)) {
            double epsilon = this.tolerance();
            int i = Math.min(a.rows(), a.columns());
            while (--i >= 0) {
                if (!(Math.abs(1.0 - a.getQuick(i, i)) > epsilon)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isUpperBidiagonal(DoubleMatrix2D a) {
        double epsilon = this.tolerance();
        int rows = a.rows();
        int columns = a.columns();
        int row = rows;
        while (--row >= 0) {
            int column = columns;
            while (--column >= 0) {
                if (row == column || row == column - 1 || !(Math.abs(a.getQuick(row, column)) > epsilon)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isUpperTriangular(DoubleMatrix2D a) {
        int columns;
        double epsilon = this.tolerance();
        int rows = a.rows();
        int column = columns = a.columns();
        while (--column >= 0) {
            int row = rows;
            while (--row > column) {
                if (!(Math.abs(a.getQuick(row, column)) > epsilon)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isZero(DoubleMatrix2D a) {
        return this.equals(a, 0.0);
    }

    public int lowerBandwidth(DoubleMatrix2D a) {
        int rows;
        Property.checkSquare(a);
        double epsilon = this.tolerance();
        int k = rows = a.rows();
        while (--k >= 0) {
            int i = rows - k;
            while (--i >= 0) {
                int j = i + k;
                if (!(Math.abs(a.getQuick(j, i)) > epsilon)) continue;
                return k;
            }
        }
        return 0;
    }

    public int semiBandwidth(DoubleMatrix2D a) {
        int rows;
        Property.checkSquare(a);
        double epsilon = this.tolerance();
        int k = rows = a.rows();
        while (--k >= 0) {
            int i = rows - k;
            while (--i >= 0) {
                int j = i + k;
                if (!(Math.abs(a.getQuick(j, i)) <= epsilon)) {
                    return k + 1;
                }
                if (!(Math.abs(a.getQuick(i, j)) > epsilon)) continue;
                return k + 1;
            }
        }
        return 1;
    }

    public double tolerance() {
        return this.tolerance;
    }

    public int upperBandwidth(DoubleMatrix2D a) {
        int rows;
        Property.checkSquare(a);
        double epsilon = this.tolerance();
        int k = rows = a.rows();
        while (--k >= 0) {
            int i = rows - k;
            while (--i >= 0) {
                int j = i + k;
                if (Math.abs(a.getQuick(i, j)) <= epsilon) continue;
                return k;
            }
        }
        return 0;
    }
}

