/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.statistics;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.solr.analytics.statistics.AbstractDelegatingStatsCollector;
import org.apache.solr.analytics.statistics.StatsCollector;
import org.apache.solr.analytics.util.PercentileCalculator;

public class PercentileStatsCollector
extends AbstractDelegatingStatsCollector {
    public final List<Comparable> values = new ArrayList<Comparable>();
    public static final Pattern PERCENTILE_PATTERN = Pattern.compile("perc(?:entile)?_(\\d+)", 2);
    protected final double[] percentiles;
    protected final String[] percentileNames;
    protected Comparable[] results;

    public PercentileStatsCollector(StatsCollector delegate, double[] percentiles, String[] percentileNames) {
        super(delegate);
        this.percentiles = percentiles;
        this.percentileNames = percentileNames;
    }

    @Override
    public Comparable getStat(String stat) {
        for (int i = 0; i < this.percentiles.length; ++i) {
            if (!stat.equals(this.percentileNames[i])) continue;
            if (this.results != null) {
                return this.results[i];
            }
            return null;
        }
        return this.delegate.getStat(stat);
    }

    @Override
    public void compute() {
        this.delegate.compute();
        this.results = this.values.size() > 0 ? (Comparable[])Iterables.toArray(this.getPercentiles(), Comparable.class) : null;
    }

    protected List<Comparable> getPercentiles() {
        return PercentileCalculator.getPercentiles(this.values, this.percentiles);
    }

    @Override
    public void collect(int doc) {
        super.collect(doc);
        if (this.value.exists) {
            this.values.add((Comparable)this.value.toObject());
        }
    }
}

