/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.Map;
import net.sf.saxon.Controller;
import net.sf.saxon.evpull.EventIterator;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.ComponentBody;
import net.sf.saxon.expr.instruct.UserFunctionParameter;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.Annotation;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserFunction
extends ComponentBody {
    private StructuredQName functionName;
    private boolean tailCalls = false;
    private boolean tailRecursive = false;
    private UserFunctionParameter[] parameterDefinitions;
    private SequenceType resultType;
    protected int evaluationMode = -1;
    private boolean isUpdating = false;
    private int inlineable = -1;
    private Map<StructuredQName, Annotation> annotationMap;

    @Override
    public int getComponentKind() {
        return 155;
    }

    public void setFunctionName(StructuredQName name) {
        this.functionName = name;
    }

    public StructuredQName getFunctionName() {
        return this.functionName;
    }

    @Override
    public StructuredQName getObjectName() {
        return this.functionName;
    }

    public SymbolicName getSymbolicName() {
        return new SymbolicName(155, this.functionName, this.getNumberOfArguments());
    }

    public Callable asCallable() {
        return new Callable(){

            public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
                XPathContextMajor c2 = context.newCleanContext();
                c2.setCurrentComponent(UserFunction.this.getDeclaringComponent());
                return UserFunction.this.call(c2, arguments);
            }
        };
    }

    public void setAnnotationMap(Map<StructuredQName, Annotation> map) {
        this.annotationMap = map;
    }

    public void computeEvaluationMode() {
        this.evaluationMode = this.tailRecursive ? ExpressionTool.eagerEvaluationMode(this.getBody()) : ExpressionTool.lazyEvaluationMode(this.getBody());
    }

    public Boolean isInlineable() {
        if ((this.body.getSpecialProperties() & 0x1000000) != 0) {
            return false;
        }
        Component component = this.getDeclaringComponent();
        if (component != null) {
            Visibility visibility = this.getDeclaringComponent().getVisibility();
            if (visibility == Visibility.PRIVATE || visibility == Visibility.FINAL) {
                if (this.inlineable < 0) {
                    return null;
                }
                return this.inlineable == 1;
            }
            return false;
        }
        return null;
    }

    public void setInlineable(boolean inlineable) {
        this.inlineable = inlineable ? 1 : 0;
    }

    public void setParameterDefinitions(UserFunctionParameter[] params) {
        this.parameterDefinitions = params;
    }

    public UserFunctionParameter[] getParameterDefinitions() {
        return this.parameterDefinitions;
    }

    public void setResultType(SequenceType resultType) {
        this.resultType = resultType;
    }

    public void setTailRecursive(boolean tailCalls, boolean recursiveTailCalls) {
        this.tailCalls = tailCalls;
        this.tailRecursive = recursiveTailCalls;
    }

    public boolean containsTailCalls() {
        return this.tailCalls;
    }

    public boolean isTailRecursive() {
        return this.tailRecursive;
    }

    public void setUpdating(boolean isUpdating) {
        this.isUpdating = isUpdating;
    }

    public boolean isUpdating() {
        return this.isUpdating;
    }

    public SequenceType getResultType() {
        if (this.resultType == SequenceType.ANY_SEQUENCE && this.getBody() != null && !UserFunction.containsUserFunctionCalls(this.getBody())) {
            this.resultType = SequenceType.makeSequenceType(this.getBody().getItemType(), this.getBody().getCardinality());
        }
        return this.resultType;
    }

    public SequenceType getDeclaredResultType() {
        return this.resultType;
    }

    private static boolean containsUserFunctionCalls(Expression exp) {
        if (exp instanceof UserFunctionCall) {
            return true;
        }
        for (Operand o : exp.operands()) {
            if (!UserFunction.containsUserFunctionCalls(o.getExpression())) continue;
            return true;
        }
        return false;
    }

    public SequenceType getArgumentType(int n) {
        return this.parameterDefinitions[n].getRequiredType();
    }

    public int getEvaluationMode() {
        if (this.evaluationMode == -1) {
            this.computeEvaluationMode();
        }
        return this.evaluationMode;
    }

    public int getNumberOfArguments() {
        return this.parameterDefinitions.length;
    }

    public boolean isMemoFunction() {
        return false;
    }

    public Sequence call(XPathContextMajor context, Sequence[] actualArgs) throws XPathException {
        Sequence result;
        if (this.evaluationMode == -1) {
            this.computeEvaluationMode();
        }
        context.setStackFrame(this.getStackFrameMap(), actualArgs);
        try {
            result = ExpressionTool.evaluate(this.getBody(), this.evaluationMode, context, 1);
        }
        catch (XPathException err) {
            err.maybeSetLocation(this);
            throw err;
        }
        catch (Exception err2) {
            String message = "Internal error evaluating function " + this.getFunctionName().getDisplayName() + (this.getLineNumber() > 0 ? " at line " + this.getLineNumber() : "") + (this.getSystemId() != null ? " in module " + this.getSystemId() : "");
            throw new RuntimeException(message, err2);
        }
        return result;
    }

    public void process(Sequence[] actualArgs, XPathContextMajor context) throws XPathException {
        context.setStackFrame(this.getStackFrameMap(), actualArgs);
        this.getBody().process(context);
    }

    public EventIterator iterateEvents(Sequence[] actualArgs, XPathContextMajor context) throws XPathException {
        context.setStackFrame(this.getStackFrameMap(), actualArgs);
        return this.getBody().iterateEvents(context);
    }

    public Sequence call(Sequence[] actualArgs, Controller controller) throws XPathException {
        return this.call(controller.newXPathContext(), actualArgs);
    }

    public void callUpdating(Sequence[] actualArgs, XPathContextMajor context, PendingUpdateList pul) throws XPathException {
        context.setStackFrame(this.getStackFrameMap(), actualArgs);
        try {
            this.getBody().evaluatePendingUpdates(context, pul);
        }
        catch (XPathException err) {
            err.maybeSetLocation(this);
            throw err;
        }
    }

    @Override
    public int getConstructType() {
        return 2065;
    }
}

