/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.morphlines.solr;

import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigUtil;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.morphlines.solr.DocumentLoader;
import org.apache.solr.morphlines.solr.FileUtils;
import org.apache.solr.morphlines.solr.SafeConcurrentUpdateSolrClient;
import org.apache.solr.morphlines.solr.SolrClientDocumentLoader;
import org.apache.solr.morphlines.solr.SolrMorphlineContext;
import org.apache.solr.morphlines.solr.ZooKeeperDownloader;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.util.SystemIdResolver;
import org.kitesdk.morphline.api.MorphlineCompilationException;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.MorphlineRuntimeException;
import org.kitesdk.morphline.base.Configs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SolrLocator {
    private Config config;
    private MorphlineContext context;
    private String collectionName;
    private String zkHost;
    private String solrUrl;
    private String solrHomeDir;
    private int batchSize = 1000;
    private static final Logger LOG = LoggerFactory.getLogger(SolrLocator.class);

    protected SolrLocator(MorphlineContext context) {
        Preconditions.checkNotNull((Object)context);
        this.context = context;
    }

    public SolrLocator(Config config, MorphlineContext context) {
        this(context);
        this.config = config;
        Configs configs = new Configs();
        this.collectionName = configs.getString(config, "collection", null);
        this.zkHost = configs.getString(config, "zkHost", null);
        this.solrHomeDir = configs.getString(config, "solrHomeDir", null);
        this.solrUrl = configs.getString(config, "solrUrl", null);
        this.batchSize = configs.getInt(config, "batchSize", this.batchSize);
        LOG.trace("Constructed solrLocator: {}", (Object)this);
        configs.validateArguments(config);
    }

    public DocumentLoader getLoader() {
        int solrServerNumThreads;
        DocumentLoader loader;
        if (this.context instanceof SolrMorphlineContext && (loader = ((SolrMorphlineContext)this.context).getDocumentLoader()) != null) {
            return loader;
        }
        if (this.zkHost != null && this.zkHost.length() > 0) {
            if (this.collectionName == null || this.collectionName.length() == 0) {
                throw new MorphlineCompilationException("Parameter 'zkHost' requires that you also pass parameter 'collection'", this.config);
            }
            CloudSolrClient cloudSolrClient = new CloudSolrClient(this.zkHost);
            cloudSolrClient.setDefaultCollection(this.collectionName);
            cloudSolrClient.connect();
            return new SolrClientDocumentLoader((SolrClient)cloudSolrClient, this.batchSize);
        }
        if (this.solrUrl == null || this.solrUrl.length() == 0) {
            throw new MorphlineCompilationException("Missing parameter 'solrUrl'", this.config);
        }
        int solrServerQueueLength = solrServerNumThreads = 2;
        SafeConcurrentUpdateSolrClient server = new SafeConcurrentUpdateSolrClient(this.solrUrl, solrServerQueueLength, solrServerNumThreads);
        return new SolrClientDocumentLoader((SolrClient)server, this.batchSize);
    }

    /*
     * Loose catch block
     */
    public IndexSchema getIndexSchema() {
        IndexSchema indexSchema;
        File downloadedSolrHomeDir;
        block20: {
            IndexSchema schema;
            if (this.context instanceof SolrMorphlineContext && (schema = ((SolrMorphlineContext)this.context).getIndexSchema()) != null) {
                this.validateSchema(schema);
                return schema;
            }
            downloadedSolrHomeDir = null;
            String mySolrHomeDir = this.solrHomeDir;
            if (this.solrHomeDir == null || this.solrHomeDir.length() == 0) {
                if (this.zkHost == null || this.zkHost.length() == 0) {
                    throw new MorphlineCompilationException("Downloading a Solr schema requires either parameter 'solrHomeDir' or parameters 'zkHost' and 'collection'", this.config);
                }
                if (this.collectionName == null || this.collectionName.length() == 0) {
                    throw new MorphlineCompilationException("Parameter 'zkHost' requires that you also pass parameter 'collection'", this.config);
                }
                ZooKeeperDownloader zki = new ZooKeeperDownloader();
                try (SolrZkClient zkClient = zki.getZkClient(this.zkHost);){
                    String configName = zki.readConfigName(zkClient, this.collectionName);
                    downloadedSolrHomeDir = Files.createTempDir();
                    downloadedSolrHomeDir = zki.downloadConfigDir(zkClient, configName, downloadedSolrHomeDir);
                    mySolrHomeDir = downloadedSolrHomeDir.getAbsolutePath();
                }
            }
            LOG.debug("SolrLocator loading IndexSchema from dir {}", (Object)mySolrHomeDir);
            SolrResourceLoader loader = new SolrResourceLoader(mySolrHomeDir);
            SolrConfig solrConfig = new SolrConfig(loader, "solrconfig.xml", null);
            InputSource is = new InputSource(loader.openSchema("schema.xml"));
            is.setSystemId(SystemIdResolver.createSystemIdFromResourceName((String)"schema.xml"));
            IndexSchema schema2 = new IndexSchema(solrConfig, "schema.xml", is);
            this.validateSchema(schema2);
            indexSchema = schema2;
            if (downloadedSolrHomeDir == null) break block20;
            try {
                FileUtils.deleteDirectory(downloadedSolrHomeDir);
            }
            catch (IOException e) {
                LOG.warn("Cannot delete tmp directory", (Throwable)e);
            }
        }
        return indexSchema;
        {
            catch (IOException | ParserConfigurationException | SAXException e) {
                try {
                    throw new MorphlineRuntimeException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (downloadedSolrHomeDir != null) {
                        try {
                            FileUtils.deleteDirectory(downloadedSolrHomeDir);
                        }
                        catch (IOException e2) {
                            LOG.warn("Cannot delete tmp directory", (Throwable)e2);
                        }
                    }
                    throw throwable;
                }
            }
        }
    }

    private void validateSchema(IndexSchema schema) {
        if (schema.getUniqueKeyField() == null) {
            throw new MorphlineCompilationException("Solr schema.xml is missing unique key field", this.config);
        }
        if (!schema.getUniqueKeyField().isRequired()) {
            throw new MorphlineCompilationException("Solr schema.xml must contain a required unique key field", this.config);
        }
    }

    public String toString() {
        return this.toConfig(null).root().render(ConfigRenderOptions.concise());
    }

    public Config toConfig(String key) {
        String json = "";
        if (key != null) {
            json = this.toJson(key) + " : ";
        }
        json = json + "{ collection : " + this.toJson(this.collectionName) + ", " + " zkHost : " + this.toJson(this.zkHost) + ", " + " solrUrl : " + this.toJson(this.solrUrl) + ", " + " solrHomeDir : " + this.toJson(this.solrHomeDir) + ", " + " batchSize : " + this.toJson(this.batchSize) + " " + "}";
        return ConfigFactory.parseString((String)json);
    }

    private String toJson(Object key) {
        String str = key == null ? "" : key.toString();
        str = ConfigUtil.quoteString((String)str);
        return str;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public String getZkHost() {
        return this.zkHost;
    }

    public void setZkHost(String zkHost) {
        this.zkHost = zkHost;
    }

    public String getSolrHomeDir() {
        return this.solrHomeDir;
    }

    public void setSolrHomeDir(String solrHomeDir) {
        this.solrHomeDir = solrHomeDir;
    }

    public String getServerUrl() {
        return this.solrUrl;
    }

    public void setServerUrl(String solrUrl) {
        this.solrUrl = solrUrl;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }
}

