/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.request;

import java.util.Locale;
import org.apache.solr.analytics.request.AbstractFieldFacetRequest;
import org.apache.solr.schema.SchemaField;

public class FieldFacetRequest
extends AbstractFieldFacetRequest {
    private FacetSortSpecification sort = null;
    private FacetSortDirection dir = null;
    private int limit = -1;
    private int offset;
    private boolean missing;
    private boolean hidden = false;

    public FieldFacetRequest(SchemaField field) {
        super(field);
    }

    public FacetSortDirection getDirection() {
        return this.dir;
    }

    public void setDirection(String dir) {
        this.dir = FacetSortDirection.fromExternal(dir);
        if (this.sort != null) {
            this.sort.setDirection(this.dir);
        }
    }

    public FacetSortSpecification getSort() {
        return this.sort;
    }

    public void setSort(FacetSortSpecification sort) {
        this.sort = sort;
    }

    public boolean showsMissing() {
        return this.missing;
    }

    public void showMissing(boolean missing) {
        this.missing = missing;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public String toString() {
        return "<FieldFacetRequest field=" + this.field.getName() + (this.sort == null ? "" : " sort=" + this.sort) + " limit=" + this.limit + " offset=" + this.offset + ">";
    }

    public static class FacetSortSpecification {
        private String statistic;
        private FacetSortDirection direction = FacetSortDirection.DESCENDING;

        public FacetSortSpecification() {
        }

        public FacetSortSpecification(String statistic) {
            this.statistic = statistic;
        }

        public FacetSortSpecification(String statistic, FacetSortDirection direction) {
            this(statistic);
            this.direction = direction;
        }

        public String getStatistic() {
            return this.statistic;
        }

        public void setStatistic(String statistic) {
            this.statistic = statistic;
        }

        public FacetSortDirection getDirection() {
            return this.direction;
        }

        public void setDirection(FacetSortDirection direction) {
            this.direction = direction;
        }

        public static FacetSortSpecification fromExternal(String spec) {
            String[] parts = spec.split(" ", 2);
            if (parts.length == 1) {
                return new FacetSortSpecification(parts[0]);
            }
            return new FacetSortSpecification(parts[0], FacetSortDirection.fromExternal(parts[1]));
        }

        public String toString() {
            return "<SortSpec stat=" + this.statistic + " dir=" + (Object)((Object)this.direction) + ">";
        }
    }

    public static enum FacetSortDirection {
        ASCENDING,
        DESCENDING;


        public static FacetSortDirection fromExternal(String value) {
            String sort = value.toLowerCase(Locale.ROOT);
            if ("asc".equals(sort)) {
                return ASCENDING;
            }
            if ("ascending".equals(sort)) {
                return ASCENDING;
            }
            if ("desc".equals(sort)) {
                return DESCENDING;
            }
            if ("descending".equals(sort)) {
                return DESCENDING;
            }
            return Enum.valueOf(FacetSortDirection.class, value);
        }
    }
}

