/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.hadoop.morphline;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.annotations.Beta;
import com.google.common.base.Joiner;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.hadoop.PathParts;
import org.apache.solr.hadoop.Utils;
import org.apache.solr.hadoop.morphline.MorphlineCounters;
import org.apache.solr.morphlines.solr.DocumentLoader;
import org.apache.solr.morphlines.solr.SolrLocator;
import org.apache.solr.morphlines.solr.SolrMorphlineContext;
import org.apache.solr.schema.IndexSchema;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.ExceptionHandler;
import org.kitesdk.morphline.api.MorphlineCompilationException;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.base.Compiler;
import org.kitesdk.morphline.base.FaultTolerance;
import org.kitesdk.morphline.base.Notifications;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class MorphlineMapRunner {
    private MorphlineContext morphlineContext;
    private Command morphline;
    private IndexSchema schema;
    private Map<String, String> commandLineMorphlineHeaders;
    private boolean disableFileOpen;
    private String morphlineFileAndId;
    private final Timer elapsedTime;
    public static final String MORPHLINE_FILE_PARAM = "morphlineFile";
    public static final String MORPHLINE_ID_PARAM = "morphlineId";
    public static final String MORPHLINE_VARIABLE_PARAM = "morphlineVariable";
    public static final String MORPHLINE_FIELD_PREFIX = "morphlineField.";
    public static final String DISABLE_FILE_OPEN = "morphlineDisableFileOpen";
    private static final Logger LOG = LoggerFactory.getLogger(MorphlineMapRunner.class);

    MorphlineContext getMorphlineContext() {
        return this.morphlineContext;
    }

    IndexSchema getSchema() {
        return this.schema;
    }

    public MorphlineMapRunner(Configuration configuration, DocumentLoader loader, String solrHomeDir) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("CWD is {}", (Object)new File(".").getCanonicalPath());
            TreeMap map = new TreeMap();
            for (Map.Entry entry : configuration) {
                map.put(entry.getKey(), entry.getValue());
            }
            LOG.trace("Configuration:\n{}", (Object)Joiner.on((String)"\n").join(map.entrySet()));
        }
        FaultTolerance faultTolerance = new FaultTolerance(configuration.getBoolean("isProductionMode", false), configuration.getBoolean("isIgnoringRecoverableExceptions", false), configuration.get("recoverableExceptionClasses", SolrServerException.class.getName()));
        this.morphlineContext = new SolrMorphlineContext.Builder().setDocumentLoader(loader).setExceptionHandler((ExceptionHandler)faultTolerance).setMetricRegistry(new MetricRegistry()).build();
        class MySolrLocator
        extends SolrLocator {
            public MySolrLocator(MorphlineContext ctx) {
                super(ctx);
            }
        }
        MySolrLocator locator = new MySolrLocator(this.morphlineContext);
        locator.setSolrHomeDir(solrHomeDir);
        this.schema = locator.getIndexSchema();
        this.morphlineContext = new SolrMorphlineContext.Builder().setIndexSchema(this.schema).setDocumentLoader(loader).setExceptionHandler((ExceptionHandler)faultTolerance).setMetricRegistry(this.morphlineContext.getMetricRegistry()).build();
        String morphlineFile = configuration.get(MORPHLINE_FILE_PARAM);
        String morphlineId = configuration.get(MORPHLINE_ID_PARAM);
        if (morphlineFile == null || morphlineFile.trim().length() == 0) {
            throw new MorphlineCompilationException("Missing parameter: morphlineFile", null);
        }
        HashMap morphlineVariables = new HashMap();
        for (Map.Entry entry : configuration) {
            String variablePrefix = "morphlineVariable.";
            if (!((String)entry.getKey()).startsWith(variablePrefix)) continue;
            morphlineVariables.put(((String)entry.getKey()).substring(variablePrefix.length()), entry.getValue());
        }
        Config override = ConfigFactory.parseMap(morphlineVariables);
        this.morphline = new Compiler().compile(new File(morphlineFile), morphlineId, this.morphlineContext, null, new Config[]{override});
        this.morphlineFileAndId = morphlineFile + "@" + morphlineId;
        this.disableFileOpen = configuration.getBoolean(DISABLE_FILE_OPEN, false);
        LOG.debug("disableFileOpen: {}", (Object)this.disableFileOpen);
        this.commandLineMorphlineHeaders = new HashMap<String, String>();
        for (Map.Entry entry : configuration) {
            if (!((String)entry.getKey()).startsWith(MORPHLINE_FIELD_PREFIX)) continue;
            this.commandLineMorphlineHeaders.put(((String)entry.getKey()).substring(MORPHLINE_FIELD_PREFIX.length()), (String)entry.getValue());
        }
        LOG.debug("Headers, including MIME types, passed by force from the CLI to morphline: {}", this.commandLineMorphlineHeaders);
        String metricName = MetricRegistry.name((String)Utils.getShortClassName(this.getClass()), (String[])new String[]{"elapsedTime"});
        this.elapsedTime = this.morphlineContext.getMetricRegistry().timer(metricName);
        Notifications.notifyBeginTransaction((Command)this.morphline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void map(String value, Configuration configuration, Mapper.Context context) throws IOException {
        LOG.info("Processing file {}", (Object)value);
        InputStream in = null;
        Record record = null;
        Timer.Context timerContext = this.elapsedTime.time();
        try {
            PathParts parts = new PathParts(value.toString(), configuration);
            record = this.getRecord(parts);
            if (record == null) {
                return;
            }
            for (Map.Entry<String, String> entry : this.commandLineMorphlineHeaders.entrySet()) {
                record.replaceValues(entry.getKey(), (Object)entry.getValue());
            }
            long fileLength = parts.getFileStatus().getLen();
            in = this.disableFileOpen ? new ByteArrayInputStream(new byte[0]) : new BufferedInputStream((InputStream)parts.getFileSystem().open(parts.getUploadPath()));
            record.put("_attachment_body", (Object)in);
            Notifications.notifyStartSession((Command)this.morphline);
            if (!this.morphline.process(record)) {
                LOG.warn("Morphline {} failed to process record: {}", (Object)this.morphlineFileAndId, (Object)record);
            }
            if (context != null) {
                context.getCounter(MorphlineCounters.class.getName(), MorphlineCounters.FILES_READ.toString()).increment(1L);
                context.getCounter(MorphlineCounters.class.getName(), MorphlineCounters.FILE_BYTES_READ.toString()).increment(fileLength);
            }
        }
        catch (Exception e) {
            LOG.error("Unable to process file " + value, (Throwable)e);
            if (context != null) {
                context.getCounter(this.getClass().getName() + ".errors", e.getClass().getName()).increment(1L);
            }
            this.morphlineContext.getExceptionHandler().handleException((Throwable)e, record);
        }
        finally {
            timerContext.stop();
            if (in != null) {
                in.close();
            }
        }
    }

    protected Record getRecord(PathParts parts) {
        FileStatus stats;
        try {
            stats = parts.getFileStatus();
        }
        catch (IOException e) {
            stats = null;
        }
        if (stats == null) {
            LOG.warn("Ignoring file that somehow has become unavailable since the job was submitted: {}", (Object)parts.getUploadURL());
            return null;
        }
        Record headers = new Record();
        headers.put("base_id", (Object)parts.getId());
        headers.put("_attachment_name", (Object)parts.getName());
        headers.put("file_upload_url", (Object)parts.getUploadURL());
        headers.put("file_download_url", (Object)parts.getDownloadURL());
        headers.put("file_scheme", (Object)parts.getScheme());
        headers.put("file_host", (Object)parts.getHost());
        headers.put("file_port", (Object)String.valueOf(parts.getPort()));
        headers.put("file_path", (Object)parts.getURIPath());
        headers.put("file_name", (Object)parts.getName());
        headers.put("file_last_modified", (Object)String.valueOf(stats.getModificationTime()));
        headers.put("file_length", (Object)String.valueOf(stats.getLen()));
        headers.put("file_owner", (Object)stats.getOwner());
        headers.put("file_group", (Object)stats.getGroup());
        headers.put("file_permissions_user", (Object)stats.getPermission().getUserAction().SYMBOL);
        headers.put("file_permissions_group", (Object)stats.getPermission().getGroupAction().SYMBOL);
        headers.put("file_permissions_other", (Object)stats.getPermission().getOtherAction().SYMBOL);
        headers.put("file_permissions_stickybit", (Object)String.valueOf(stats.getPermission().getStickyBit()));
        return headers;
    }

    public void cleanup() {
        Notifications.notifyCommitTransaction((Command)this.morphline);
        Notifications.notifyShutdown((Command)this.morphline);
    }
}

