/*
 * Decompiled with CFR 0.152.
 */
package morfologik.util;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class FileUtils {
    private FileUtils() {
    }

    public static void assertExists(File fsaFile, boolean requireFile, boolean requireDirectory) throws IOException {
        if (!fsaFile.exists()) {
            throw new IOException("File does not exist: " + fsaFile.getAbsolutePath());
        }
        if (!(!requireFile || fsaFile.isFile() && fsaFile.canRead())) {
            throw new IOException("File cannot be read: " + fsaFile.getAbsolutePath());
        }
        if (requireDirectory && !fsaFile.isDirectory()) {
            throw new IOException("Not a directory: " + fsaFile.getAbsolutePath());
        }
    }

    public static void close(Closeable ... closeables) {
        for (Closeable c : closeables) {
            if (c == null) continue;
            try {
                c.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public static byte[] readFully(InputStream stream) throws IOException {
        int bytesCount;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(16384);
        byte[] buffer = new byte[8192];
        while ((bytesCount = stream.read(buffer)) > 0) {
            baos.write(buffer, 0, bytesCount);
        }
        return baos.toByteArray();
    }

    public static void readFully(InputStream in, byte[] array) throws IOException {
        int cnt;
        int offset = 0;
        while ((cnt = in.read(array, offset, array.length - offset)) > 0 && (offset += cnt) != array.length) {
        }
        if (cnt < 0) {
            throw new EOFException();
        }
    }

    public static int readInt(InputStream in) throws IOException {
        int v = 0;
        for (int i = 0; i < 4; ++i) {
            v = v << 8 | FileUtils.readByte(in) & 0xFF;
        }
        return v;
    }

    public static void writeInt(OutputStream os, int v) throws IOException {
        os.write(v >>> 24);
        os.write(v >>> 16 & 0xFF);
        os.write(v >>> 8 & 0xFF);
        os.write(v & 0xFF);
    }

    public static short readShort(InputStream in) throws IOException {
        return (short)(FileUtils.readByte(in) << 8 | FileUtils.readByte(in) & 0xFF);
    }

    public static byte readByte(InputStream in) throws IOException {
        int b = in.read();
        if (b == -1) {
            throw new EOFException();
        }
        return (byte)b;
    }

    public static void writeShort(OutputStream os, short v) throws IOException {
        os.write(v >>> 8 & 0xFF);
        os.write(v & 0xFF);
    }
}

