/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support.lob;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import org.springframework.util.FileCopyUtils;

class PassThroughClob
implements Clob {
    private String content;
    private Reader characterStream;
    private InputStream asciiStream;
    private long contentLength;

    public PassThroughClob(String content) {
        this.content = content;
        this.contentLength = content.length();
    }

    public PassThroughClob(Reader characterStream, long contentLength) {
        this.characterStream = characterStream;
        this.contentLength = contentLength;
    }

    public PassThroughClob(InputStream asciiStream, long contentLength) {
        this.asciiStream = asciiStream;
        this.contentLength = contentLength;
    }

    public long length() throws SQLException {
        return this.contentLength;
    }

    public Reader getCharacterStream() throws SQLException {
        try {
            if (this.content != null) {
                return new StringReader(this.content);
            }
            if (this.characterStream != null) {
                return this.characterStream;
            }
            return new InputStreamReader(this.asciiStream, "US-ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            throw new SQLException("US-ASCII encoding not supported: " + ex);
        }
    }

    public InputStream getAsciiStream() throws SQLException {
        try {
            if (this.content != null) {
                return new ByteArrayInputStream(this.content.getBytes("US-ASCII"));
            }
            if (this.characterStream != null) {
                String tempContent = FileCopyUtils.copyToString((Reader)this.characterStream);
                return new ByteArrayInputStream(tempContent.getBytes("US-ASCII"));
            }
            return this.asciiStream;
        }
        catch (UnsupportedEncodingException ex) {
            throw new SQLException("US-ASCII encoding not supported: " + ex);
        }
        catch (IOException ex) {
            throw new SQLException("Failed to read stream content: " + ex);
        }
    }

    public Reader getCharacterStream(long pos, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Writer setCharacterStream(long pos) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public OutputStream setAsciiStream(long pos) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public String getSubString(long pos, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int setString(long pos, String str2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int setString(long pos, String str2, int offset, int len) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public long position(String searchstr, long start) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public long position(Clob searchstr, long start) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void truncate(long len) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void free() throws SQLException {
    }
}

