/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jca.work;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import javax.naming.NamingException;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkManager;
import javax.resource.spi.work.WorkRejectedException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.core.task.TaskRejectedException;
import org.springframework.core.task.TaskTimeoutException;
import org.springframework.jca.context.BootstrapContextAware;
import org.springframework.jca.work.DelegatingWork;
import org.springframework.jca.work.SimpleTaskWorkManager;
import org.springframework.jndi.JndiLocatorSupport;
import org.springframework.scheduling.SchedulingException;
import org.springframework.scheduling.SchedulingTaskExecutor;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkManagerTaskExecutor
extends JndiLocatorSupport
implements SchedulingTaskExecutor,
AsyncTaskExecutor,
WorkManager,
BootstrapContextAware,
InitializingBean {
    private WorkManager workManager;
    private String workManagerName;
    private boolean blockUntilStarted = false;
    private boolean blockUntilCompleted = false;
    private WorkListener workListener;

    public WorkManagerTaskExecutor() {
    }

    public WorkManagerTaskExecutor(WorkManager workManager) {
        this.setWorkManager(workManager);
    }

    public void setWorkManager(WorkManager workManager) {
        Assert.notNull((Object)workManager, (String)"WorkManager must not be null");
        this.workManager = workManager;
    }

    public void setWorkManagerName(String workManagerName) {
        this.workManagerName = workManagerName;
    }

    @Override
    public void setBootstrapContext(BootstrapContext bootstrapContext) {
        Assert.notNull((Object)bootstrapContext, (String)"BootstrapContext must not be null");
        this.workManager = bootstrapContext.getWorkManager();
    }

    public void setBlockUntilStarted(boolean blockUntilStarted) {
        this.blockUntilStarted = blockUntilStarted;
    }

    public void setBlockUntilCompleted(boolean blockUntilCompleted) {
        this.blockUntilCompleted = blockUntilCompleted;
    }

    public void setWorkListener(WorkListener workListener) {
        this.workListener = workListener;
    }

    @Override
    public void afterPropertiesSet() throws NamingException {
        if (this.workManager == null) {
            this.workManager = this.workManagerName != null ? (WorkManager)this.lookup(this.workManagerName, WorkManager.class) : this.getDefaultWorkManager();
        }
    }

    protected WorkManager getDefaultWorkManager() {
        return new SimpleTaskWorkManager();
    }

    public void execute(Runnable task) {
        this.execute(task, Long.MAX_VALUE);
    }

    public void execute(Runnable task, long startTimeout) {
        Assert.state((this.workManager != null ? 1 : 0) != 0, (String)"No WorkManager specified");
        DelegatingWork work = new DelegatingWork(task);
        try {
            if (this.blockUntilCompleted) {
                if (startTimeout != Long.MAX_VALUE || this.workListener != null) {
                    this.workManager.doWork((Work)work, startTimeout, null, this.workListener);
                } else {
                    this.workManager.doWork((Work)work);
                }
            } else if (this.blockUntilStarted) {
                if (startTimeout != Long.MAX_VALUE || this.workListener != null) {
                    this.workManager.startWork((Work)work, startTimeout, null, this.workListener);
                } else {
                    this.workManager.startWork((Work)work);
                }
            } else if (startTimeout != Long.MAX_VALUE || this.workListener != null) {
                this.workManager.scheduleWork((Work)work, startTimeout, null, this.workListener);
            } else {
                this.workManager.scheduleWork((Work)work);
            }
        }
        catch (WorkRejectedException ex) {
            if ("1".equals(ex.getErrorCode())) {
                throw new TaskTimeoutException("JCA WorkManager rejected task because of timeout: " + task, (Throwable)ex);
            }
            throw new TaskRejectedException("JCA WorkManager rejected task: " + task, (Throwable)ex);
        }
        catch (WorkException ex) {
            throw new SchedulingException("Could not schedule task on JCA WorkManager", (Throwable)ex);
        }
    }

    public Future<?> submit(Runnable task) {
        FutureTask<Object> future = new FutureTask<Object>(task, null);
        this.execute(future, Long.MAX_VALUE);
        return future;
    }

    public <T> Future<T> submit(Callable<T> task) {
        FutureTask<T> future = new FutureTask<T>(task);
        this.execute(future, Long.MAX_VALUE);
        return future;
    }

    public boolean prefersShortLivedTasks() {
        return true;
    }

    public void doWork(Work work) throws WorkException {
        this.workManager.doWork(work);
    }

    public void doWork(Work work, long delay, ExecutionContext executionContext, WorkListener workListener) throws WorkException {
        this.workManager.doWork(work, delay, executionContext, workListener);
    }

    public long startWork(Work work) throws WorkException {
        return this.workManager.startWork(work);
    }

    public long startWork(Work work, long delay, ExecutionContext executionContext, WorkListener workListener) throws WorkException {
        return this.workManager.startWork(work, delay, executionContext, workListener);
    }

    public void scheduleWork(Work work) throws WorkException {
        this.workManager.scheduleWork(work);
    }

    public void scheduleWork(Work work, long delay, ExecutionContext executionContext, WorkListener workListener) throws WorkException {
        this.workManager.scheduleWork(work, delay, executionContext, workListener);
    }
}

