/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.support;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.core.CrudInvoker;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.support.RepositoryFactoryInformation;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.support.CrudRepositoryInvoker;
import org.springframework.data.repository.support.ReflectionRepositoryInvoker;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class Repositories
implements Iterable<Class<?>> {
    static final Repositories NONE = new Repositories();
    private static final RepositoryFactoryInformation<Object, Serializable> EMPTY_REPOSITORY_FACTORY_INFO = EmptyRepositoryFactoryInformation.INSTANCE;
    private final BeanFactory beanFactory;
    private final Map<Class<?>, String> repositoryBeanNames;
    private final Map<Class<?>, RepositoryFactoryInformation<Object, Serializable>> repositoryFactoryInfos;

    private Repositories() {
        this.beanFactory = null;
        this.repositoryBeanNames = Collections.emptyMap();
        this.repositoryFactoryInfos = Collections.emptyMap();
    }

    public Repositories(ListableBeanFactory factory) {
        Assert.notNull((Object)factory);
        this.beanFactory = factory;
        this.repositoryFactoryInfos = new HashMap();
        this.repositoryBeanNames = new HashMap();
        this.populateRepositoryFactoryInformation(factory);
    }

    private void populateRepositoryFactoryInformation(ListableBeanFactory factory) {
        for (String name : BeanFactoryUtils.beanNamesForTypeIncludingAncestors(factory, RepositoryFactoryInformation.class, false, false)) {
            RepositoryFactoryInformation repositoryFactoryInformation = this.beanFactory.getBean(name, RepositoryFactoryInformation.class);
            Class userDomainType = ClassUtils.getUserClass(repositoryFactoryInformation.getRepositoryInformation().getDomainType());
            this.repositoryFactoryInfos.put(userDomainType, repositoryFactoryInformation);
            this.repositoryBeanNames.put(userDomainType, BeanFactoryUtils.transformedBeanName(name));
        }
    }

    public boolean hasRepositoryFor(Class<?> domainClass) {
        Assert.notNull(domainClass, (String)"Domain class must not be null!");
        return this.repositoryFactoryInfos.containsKey(domainClass);
    }

    public Object getRepositoryFor(Class<?> domainClass) {
        Assert.notNull(domainClass, (String)"Domain class must not be null!");
        String repositoryBeanName = this.repositoryBeanNames.get(domainClass);
        return repositoryBeanName == null || this.beanFactory == null ? null : this.beanFactory.getBean(repositoryBeanName);
    }

    private RepositoryFactoryInformation<Object, Serializable> getRepositoryFactoryInfoFor(Class<?> domainClass) {
        Assert.notNull(domainClass, (String)"Domain class must not be null!");
        RepositoryFactoryInformation<Object, Serializable> repositoryInfo = this.repositoryFactoryInfos.get(ClassUtils.getUserClass(domainClass));
        return repositoryInfo == null ? EMPTY_REPOSITORY_FACTORY_INFO : repositoryInfo;
    }

    public <T, S extends Serializable> EntityInformation<T, S> getEntityInformationFor(Class<?> domainClass) {
        Assert.notNull(domainClass, (String)"Domain class must not be null!");
        return this.getRepositoryFactoryInfoFor(domainClass).getEntityInformation();
    }

    public RepositoryInformation getRepositoryInformationFor(Class<?> domainClass) {
        Assert.notNull(domainClass, (String)"Domain class must not be null!");
        RepositoryFactoryInformation<Object, Serializable> information = this.getRepositoryFactoryInfoFor(domainClass);
        return information == EMPTY_REPOSITORY_FACTORY_INFO ? null : information.getRepositoryInformation();
    }

    public PersistentEntity<?, ?> getPersistentEntity(Class<?> domainClass) {
        Assert.notNull(domainClass, (String)"Domain class must not be null!");
        return this.getRepositoryFactoryInfoFor(domainClass).getPersistentEntity();
    }

    public List<QueryMethod> getQueryMethodsFor(Class<?> domainClass) {
        Assert.notNull(domainClass, (String)"Domain class must not be null!");
        return this.getRepositoryFactoryInfoFor(domainClass).getQueryMethods();
    }

    public <T> CrudInvoker<T> getCrudInvoker(Class<T> domainClass) {
        Object repository = this.getRepositoryFor(domainClass);
        Assert.notNull((Object)repository, (String)String.format("No repository found for domain class: %s", domainClass));
        if (repository instanceof CrudRepository) {
            return new CrudRepositoryInvoker((CrudRepository)repository);
        }
        return new ReflectionRepositoryInvoker(repository, this.getRepositoryInformationFor(domainClass).getCrudMethods());
    }

    @Override
    public Iterator<Class<?>> iterator() {
        return this.repositoryFactoryInfos.keySet().iterator();
    }

    private static enum EmptyRepositoryFactoryInformation implements RepositoryFactoryInformation<Object, Serializable>
    {
        INSTANCE;


        @Override
        public EntityInformation<Object, Serializable> getEntityInformation() {
            return null;
        }

        @Override
        public RepositoryInformation getRepositoryInformation() {
            return null;
        }

        @Override
        public PersistentEntity<?, ?> getPersistentEntity() {
            return null;
        }

        @Override
        public List<QueryMethod> getQueryMethods() {
            return Collections.emptyList();
        }
    }
}

