/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.Date;
import javax.persistence.Query;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.repository.query.Parameters;
import org.springframework.util.Assert;

public class ParameterBinder {
    private final JpaParameters parameters;
    private final Object[] values;

    public ParameterBinder(JpaParameters parameters, Object[] values) {
        Assert.notNull((Object)parameters);
        Assert.notNull((Object)values);
        Assert.isTrue((parameters.getNumberOfParameters() == values.length ? (byte)1 : 0) != 0, (String)"Invalid number of parameters given!");
        this.parameters = parameters;
        this.values = (Object[])values.clone();
    }

    ParameterBinder(JpaParameters parameters) {
        this(parameters, new Object[0]);
    }

    public Pageable getPageable() {
        if (!this.parameters.hasPageableParameter()) {
            return null;
        }
        return (Pageable)this.values[this.parameters.getPageableIndex()];
    }

    public Sort getSort() {
        if (this.parameters.hasSortParameter()) {
            return (Sort)this.values[this.parameters.getSortIndex()];
        }
        if (this.parameters.hasPageableParameter() && this.getPageable() != null) {
            return this.getPageable().getSort();
        }
        return null;
    }

    public <T extends Query> T bind(T query2) {
        int methodParameterPosition = 0;
        int queryParameterPosition = 1;
        for (JpaParameters.JpaParameter parameter : this.parameters) {
            if (parameter.isBindable()) {
                Object value = this.values[methodParameterPosition];
                this.bind(query2, parameter, value, queryParameterPosition++);
            }
            ++methodParameterPosition;
        }
        return query2;
    }

    protected void bind(Query query2, JpaParameters.JpaParameter parameter, Object value, int position) {
        if (parameter.isTemporalParameter()) {
            if (this.hasNamedParameter(query2) && parameter.isNamedParameter()) {
                query2.setParameter(parameter.getName(), (Date)value, parameter.getTemporalType());
            } else {
                query2.setParameter(position, (Date)value, parameter.getTemporalType());
            }
            return;
        }
        if (this.hasNamedParameter(query2) && parameter.isNamedParameter()) {
            query2.setParameter(parameter.getName(), value);
        } else {
            query2.setParameter(position, value);
        }
    }

    public Query bindAndPrepare(Query query2) {
        return this.bindAndPrepare(query2, this.parameters);
    }

    boolean hasNamedParameter(Query query2) {
        return QueryUtils.hasNamedParameter(query2);
    }

    private Query bindAndPrepare(Query query2, Parameters<?, ?> parameters) {
        Query result = this.bind(query2);
        if (!parameters.hasPageableParameter() || this.getPageable() == null) {
            return result;
        }
        result.setFirstResult(this.getPageable().getOffset());
        result.setMaxResults(this.getPageable().getPageSize());
        return result;
    }
}

