/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.Collections;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.query.AbstractJpaQuery;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.util.Assert;

public abstract class JpaQueryExecution {
    private static final ConversionService conversionService = new DefaultConversionService();

    public Object execute(AbstractJpaQuery query2, Object[] values) {
        Object result;
        Assert.notNull((Object)query2);
        Assert.notNull((Object)values);
        try {
            result = this.doExecute(query2, values);
        }
        catch (NoResultException e2) {
            return null;
        }
        if (result == null) {
            return result;
        }
        JpaQueryMethod queryMethod = query2.getQueryMethod();
        Class<?> requiredType = queryMethod.getReturnType();
        if (Void.TYPE.equals(requiredType) || requiredType.isAssignableFrom(result.getClass())) {
            return result;
        }
        return conversionService.convert(result, requiredType);
    }

    protected abstract Object doExecute(AbstractJpaQuery var1, Object[] var2);

    static class ModifyingExecution
    extends JpaQueryExecution {
        private final EntityManager em;

        public ModifyingExecution(JpaQueryMethod method, EntityManager em) {
            Class<?> returnType = method.getReturnType();
            boolean isVoid = Void.TYPE.equals(returnType) || Void.class.equals(returnType);
            boolean isInt = Integer.TYPE.equals(returnType) || Integer.class.equals(returnType);
            Assert.isTrue((isInt || isVoid ? (byte)1 : 0) != 0, (String)"Modifying queries can only use void or int/Integer as return type!");
            this.em = em;
        }

        @Override
        protected Object doExecute(AbstractJpaQuery query2, Object[] values) {
            int result = query2.createQuery(values).executeUpdate();
            if (this.em != null) {
                this.em.clear();
            }
            return result;
        }
    }

    static class SingleEntityExecution
    extends JpaQueryExecution {
        SingleEntityExecution() {
        }

        @Override
        protected Object doExecute(AbstractJpaQuery query2, Object[] values) {
            return query2.createQuery(values).getSingleResult();
        }
    }

    static class PagedExecution
    extends JpaQueryExecution {
        private final Parameters<?, ?> parameters;

        public PagedExecution(Parameters<?, ?> parameters) {
            this.parameters = parameters;
        }

        @Override
        protected Object doExecute(AbstractJpaQuery repositoryQuery, Object[] values) {
            TypedQuery<Long> projection = repositoryQuery.createCountQuery(values);
            List<Long> totals = projection.getResultList();
            Long total = totals.size() == 1 ? totals.get(0) : (long)totals.size();
            Query query2 = repositoryQuery.createQuery(values);
            ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.parameters, values);
            Pageable pageable = accessor.getPageable();
            List content = pageable == null || total > (long)pageable.getOffset() ? query2.getResultList() : Collections.emptyList();
            return new PageImpl(content, pageable, total);
        }
    }

    static class CollectionExecution
    extends JpaQueryExecution {
        CollectionExecution() {
        }

        @Override
        protected Object doExecute(AbstractJpaQuery query2, Object[] values) {
            return query2.createQuery(values).getResultList();
        }
    }
}

