/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import org.springframework.data.jpa.repository.query.StringQuery;
import org.springframework.data.jpa.repository.support.JpaEntityMetadata;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.Assert;

class ExpressionBasedStringQuery
extends StringQuery {
    private static final String ENTITY_NAME = "entityName";

    public ExpressionBasedStringQuery(String query2, JpaEntityMetadata<?> metadata) {
        super(ExpressionBasedStringQuery.renderQueryIfExpressionOrReturnQuery(query2, metadata));
    }

    private static String renderQueryIfExpressionOrReturnQuery(String query2, JpaEntityMetadata<?> metadata) {
        Assert.notNull((Object)query2, (String)"query must not be null!");
        Assert.notNull(metadata, (String)"metadata must not be null!");
        if (!ExpressionBasedStringQuery.containsExpression(query2)) {
            return query2;
        }
        StandardEvaluationContext evalContext = new StandardEvaluationContext();
        evalContext.setVariable(ENTITY_NAME, (Object)metadata.getEntityName());
        SpelExpressionParser parser = new SpelExpressionParser();
        Expression expr = parser.parseExpression(query2, ParserContext.TEMPLATE_EXPRESSION);
        Object result = expr.getValue((EvaluationContext)evalContext, String.class);
        return result == null ? query2 : String.valueOf(result);
    }

    private static boolean containsExpression(String query2) {
        return query2.contains("#{#entityName}");
    }
}

