/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.config;

import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class BeanComponentDefinitionBuilder {
    private final Element defaultSource;
    private final ParserContext context;

    public BeanComponentDefinitionBuilder(Element defaultSource, ParserContext context) {
        Assert.notNull((Object)defaultSource);
        Assert.notNull((Object)context);
        this.defaultSource = defaultSource;
        this.context = context;
    }

    public BeanComponentDefinition getComponent(BeanDefinitionBuilder builder) {
        Assert.notNull((Object)builder);
        AbstractBeanDefinition definition = builder.getRawBeanDefinition();
        String name = BeanDefinitionReaderUtils.generateBeanName(definition, this.context.getRegistry(), this.context.isNested());
        return this.getComponent(builder, name);
    }

    public BeanComponentDefinition getComponentIdButFallback(BeanDefinitionBuilder builder, String fallback) {
        Assert.hasText((String)fallback);
        String id = this.defaultSource.getAttribute("id");
        return this.getComponent(builder, StringUtils.hasText((String)id) ? id : fallback);
    }

    public BeanComponentDefinition getComponent(BeanDefinitionBuilder builder, String name) {
        return this.getComponent(builder, name, this.defaultSource);
    }

    public BeanComponentDefinition getComponent(BeanDefinitionBuilder builder, String name, Object rawSource) {
        Assert.notNull((Object)builder);
        Assert.hasText((String)name);
        AbstractBeanDefinition definition = builder.getRawBeanDefinition();
        definition.setSource(this.context.extractSource(rawSource));
        return new BeanComponentDefinition(definition, name);
    }
}

